/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;

public class RADeployment
implements Deployment {
    private Logger log;
    private URL deployment;
    private String deploymentName;
    private boolean activator;
    private ResourceAdapter ra;
    private JndiStrategy jndiStrategy;
    private MetadataRepository mdr;
    private Object[] cfs;
    private String[] jndis;
    private File tmpDirectory;
    private ClassLoader cl;

    public RADeployment(URL deployment, String deploymentName, boolean activator, ResourceAdapter ra, JndiStrategy jndiStrategy, MetadataRepository metadataRepository, Object[] cfs, String[] jndis, File tmpDirectory, ClassLoader cl, Logger log) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.activator = activator;
        this.ra = ra;
        this.jndiStrategy = jndiStrategy;
        this.mdr = metadataRepository;
        this.cfs = cfs;
        this.jndis = jndis;
        this.tmpDirectory = tmpDirectory;
        this.cl = cl;
        this.log = log;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void stop() {
        if (this.mdr != null) {
            try {
                this.mdr.unregisterResourceAdapter(this.deployment);
            }
            catch (Throwable t) {
                this.log.warn((Object)"Exception during unregistering deployment", t);
            }
        }
        if (this.activator) {
            this.log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
            if (this.mdr != null && this.cfs != null && this.jndis != null) {
                for (int i = 0; i < this.cfs.length; ++i) {
                    String cf = this.cfs[i].getClass().getName();
                    String jndi = this.jndis[i];
                    this.mdr.unregisterJndiMapping(this.deployment, cf, jndi);
                }
            }
            if (this.cfs != null && this.jndis != null) {
                try {
                    this.jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.jndis);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Exception during JNDI unbinding", t);
                }
            }
            if (this.ra != null) {
                this.ra.stop();
                this.ra = null;
            }
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this.tmpDirectory != null && this.tmpDirectory.exists()) {
            try {
                FileUtil fu = new FileUtil();
                fu.recursiveDelete(this.tmpDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.activator) {
            this.log.info((Object)("Undeployed: " + this.deployment.toExternalForm()));
        }
    }
}

