/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import org.jboss.jca.core.naming.ExplicitJndiStrategy;
import org.jboss.logging.Logger;

public class DsXmlDeployment
implements Deployment {
    private static Logger log = Logger.getLogger(DsXmlDeployment.class);
    private URL deployment;
    private String deploymentName;
    private Object[] cfs;
    private String[] jndis;
    private ClassLoader cl;

    public DsXmlDeployment(URL deployment, String deploymentName, Object[] cfs, String[] jndis, ClassLoader cl) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.cfs = cfs;
        this.jndis = jndis;
        this.cl = cl;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void stop() {
        log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
        if (this.cfs != null) {
            ExplicitJndiStrategy jndiStrategy = new ExplicitJndiStrategy();
            try {
                jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.jndis);
            }
            catch (Throwable t) {
                log.warn((Object)"Exception during JNDI unbinding", t);
            }
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

