/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ra;

public enum CredentialInterfaceEnum {
    PasswordCredential("javax.resource.spi.security.PasswordCredential"),
    GSSCredential("org.ietf.jgss.GSSCredential"),
    GenericCredential("javax.resource.spi.security.GenericCredential");

    private final String fullQualifiedName;

    private CredentialInterfaceEnum(String name) {
        this.fullQualifiedName = name;
    }

    public static CredentialInterfaceEnum forName(String fullQualifiedName) throws IllegalArgumentException {
        if ("javax.resource.spi.security.PasswordCredential".equals(fullQualifiedName)) {
            return PasswordCredential;
        }
        if ("org.ietf.jgss.GSSCredential".equals(fullQualifiedName)) {
            return GSSCredential;
        }
        if ("javax.resource.spi.security.GenericCredential".equals(fullQualifiedName)) {
            return GenericCredential;
        }
        throw new IllegalArgumentException("fullQualifiedName should be one of javax.resource.spi.security.PasswordCredential; org.ietf.jgss.GSSCredential;javax.resource.spi.security.GenericCredential");
    }

    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public String toString() {
        return this.fullQualifiedName;
    }
}

