/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class McMetaCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ManagedConnectionMetaData");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeEIS(def, out, indent);
        this.writeMaxConnection(def, out, indent);
        this.writeUsername(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        this.importLogging(def, out);
        out.write("import jakarta.resource.ResourceException;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import jakarta.resource.spi.ManagedConnectionMetaData;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getMcMetaClass();
    }

    private void writeEIS(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns Product name of the underlying EIS instance connected through the ManagedConnection.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Product name of the EIS instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public String getEISProductName() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getEISProductName", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns Product version of the underlying EIS instance connected through the ManagedConnection.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Product version of the EIS instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public String getEISProductVersion() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getEISProductVersion", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMaxConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns maximum limit on number of active concurrent connections ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Maximum limit for number of active concurrent connections");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public int getMaxConnections() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getMaxConnections", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return 0; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeUsername(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns name of the user associated with the ManagedConnection instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Name of the user");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public String getUserName() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getUserName", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

