/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.xml.RaXmlGen;

public class Ra10XmlGen
extends RaXmlGen {
    @Override
    public void writeXmlBody(Definition def, Writer out) throws IOException {
        this.writeConnectorVersion(out);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("<display-name>Display Name</display-name>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<vendor-name>Red Hat Inc</vendor-name>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<spec-version>1.0</spec-version>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<eis-type>Test RA</eis-type>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<version>0.1</version>");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<resourceadapter>");
        this.writeEol(out);
        this.writeOutbound(def, out, indent + 1);
        this.writeIndent(out, indent);
        out.write("</resourceadapter>");
        this.writeEol(out);
        out.write("</connector>");
        this.writeEol(out);
    }

    @Override
    void writeConnectorVersion(Writer out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeEol(out);
        this.writeEol(out);
        out.write("<!--");
        this.writeEol(out);
        this.writeheader(null, out);
        out.write("-->");
        this.writeEol(out);
        this.writeEol(out);
        out.write("<!DOCTYPE connector PUBLIC");
        this.writeEol(out);
        out.write(" \"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN\"");
        this.writeEol(out);
        out.write(" \"http://java.sun.com/dtd/connector_1_0.dtd\">");
        this.writeEol(out);
        this.writeEol(out);
        out.write("<connector>");
        this.writeEol(out);
    }

    private void writeOutbound(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("<managedconnectionfactory-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getMcfClass() + "</managedconnectionfactory-class>");
        this.writeEol(out);
        this.writeEol(out);
        if (!def.getMcfDefs().get(0).isUseCciConnection()) {
            this.writeIndent(out, indent);
            out.write("<connectionfactory-interface>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getCfInterfaceClass() + "</connectionfactory-interface>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("<connectionfactory-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getCfClass() + "</connectionfactory-impl-class>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("<connection-interface>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getConnInterfaceClass() + "</connection-interface>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("<connection-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getConnImplClass() + "</connection-impl-class>");
            this.writeEol(out);
        } else {
            this.writeIndent(out, indent);
            out.write("<connectionfactory-interface>jakarta.resource.cci.ConnectionFactory</connectionfactory-interface>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("<connectionfactory-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getCciConnFactoryClass() + "</connectionfactory-impl-class>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("<connection-interface>jakarta.resource.cci.Connection</connection-interface>");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("<connection-impl-class>" + def.getRaPackage() + "." + def.getMcfDefs().get(0).getCciConnClass() + "</connection-impl-class>");
            this.writeEol(out);
        }
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("<transaction-support>" + def.getSupportTransaction() + "</transaction-support>");
        this.writeEol(out);
        this.writeConfigPropsXml(def.getMcfDefs().get(0).getMcfConfigProps(), out, indent);
        this.writeIndent(out, indent);
        out.write("<reauthentication-support>" + def.isSupportReauthen() + "</reauthentication-support>");
        this.writeEol(out);
    }

    @Override
    void writeAsConfigPropsXml(List<ConfigPropType> props, Writer out, int indent) throws IOException {
    }
}

