/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class TestEisCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("/** Echo handler */");
        this.writeEol(out);
        out.write("public class " + this.getClassName(def) + " implements Handler");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeDefaultConstructor(def, out, indent);
        this.writeHandle(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.jboss.jca.test.eis.Handler;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.io.InputStream;");
        this.writeEol(out);
        out.write("import java.io.OutputStream;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getDefaultValue() + "Handler";
    }

    private void writeHandle(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * {@inheritDoc}");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void handle(InputStream is, OutputStream os)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("// TODO: Implement me");
        this.writeRightCurlyBracket(out, indent);
    }
}

