/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class CciConnFactoryCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ConnectionFactory");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("private Reference reference;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param cxManager ConnectionManager");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "(ConnectionManager cxManager)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConnection(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeRecordFactory(def, out, indent);
        this.writeReference(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.naming.NamingException;");
        this.writeEol(out);
        out.write("import javax.naming.Reference;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.cci.Connection;");
        this.writeEol(out);
        out.write("import javax.resource.cci.ConnectionFactory;");
        this.writeEol(out);
        out.write("import javax.resource.cci.ConnectionSpec;");
        this.writeEol(out);
        out.write("import javax.resource.cci.RecordFactory;");
        this.writeEol(out);
        out.write("import javax.resource.cci.ResourceAdapterMetaData;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionManager;");
        this.writeEol(out);
        this.writeEol(out);
        if (def.getMcfDefs().size() != 1) {
            out.write("import " + def.getRaPackage() + ".*;");
        }
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getCciConnFactoryClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets a connection to an EIS instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Connection instance the EIS instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to get a connection to");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Connection getConnection() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "(new " + def.getMcfDefs().get(this.getNumOfMcf()).getConnSpecClass() + "());");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets a connection to an EIS instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param connSpec Connection parameters and security information specified as ConnectionSpec instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Connection instance the EIS instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to get a connection to");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Connection getConnection(ConnectionSpec connSpec) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "(connSpec);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets metadata for the Resource Adapter. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return ResourceAdapterMetaData instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to get metadata information ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ResourceAdapterMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        if (def.isUseRa()) {
            out.write("return new " + def.getRaMetaClass() + "();");
        } else {
            out.write("return null;");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeRecordFactory(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets a RecordFactory instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return RecordFactory instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to create a RecordFactory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws javax.resource.NotSupportedException Operation not supported");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public RecordFactory getRecordFactory() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeReference(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the Reference instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Reference instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Reference getReference() throws NamingException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the Reference instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param reference A Reference instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setReference(Reference reference)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.reference = reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

