/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.PropsCodeGen;

public class RaCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            out.write("@Connector");
            if (def.isSupportOutbound()) {
                int i;
                out.write("(");
                this.writeEol(out);
                if (def.getAuthenMechanisms() != null && def.getAuthenMechanisms().size() > 0) {
                    this.writeIndent(out, 1);
                    out.write("authMechanisms = {");
                    this.writeEol(out);
                    for (i = 0; i < def.getAuthenMechanisms().size(); ++i) {
                        this.writeIndent(out, 2);
                        out.write("@AuthenticationMechanism(");
                        out.write("authMechanism = \"" + def.getAuthenMechanisms().get(i).getAuthMechanism());
                        out.write("\", credentialInterface = CredentialInterface." + def.getAuthenMechanisms().get(i).getCredentialInterface());
                        if (i + 1 < def.getAuthenMechanisms().size()) {
                            out.write("),");
                        } else {
                            out.write(")},");
                        }
                        this.writeEol(out);
                    }
                }
                this.writeIndent(out, 1);
                out.write("reauthenticationSupport = " + def.isSupportReauthen() + ",");
                this.writeEol(out);
                if (def.getSecurityPermissions() != null && def.getSecurityPermissions().size() > 0) {
                    this.writeIndent(out, 1);
                    out.write("securityPermissions = {");
                    this.writeEol(out);
                    for (i = 0; i < def.getSecurityPermissions().size(); ++i) {
                        this.writeIndent(out, 2);
                        out.write("@SecurityPermission(");
                        out.write("permissionSpec = \"" + def.getSecurityPermissions().get(i).getPermissionSpec() + "\")");
                        if (i + 1 < def.getSecurityPermissions().size()) {
                            out.write(",");
                        } else {
                            out.write("},");
                        }
                        this.writeEol(out);
                    }
                }
                this.writeIndent(out, 1);
                out.write("transactionSupport = TransactionSupport.TransactionSupportLevel." + def.getSupportTransaction() + ")");
            }
            this.writeEol(out);
        }
        out.write("public class " + this.getClassName(def) + " implements ResourceAdapter");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(\"" + this.getClassName(def) + "\");");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isSupportInbound()) {
            this.writeIndent(out, indent);
            out.write("/** The activations by activation spec */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("private ");
            if (def.getVersion().equals("1.6")) {
                out.write("ConcurrentHash");
            }
            out.write("Map<" + def.getAsClass() + ", " + def.getActivationClass() + "> activations;");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isSupportInbound()) {
            this.writeIndent(out, indent + 1);
            if (def.getVersion().equals("1.6")) {
                out.write("this.activations = new ConcurrentHashMap<" + def.getAsClass() + ", " + def.getActivationClass() + ">();");
            } else {
                out.write("this.activations = Collections.synchronizedMap(new HashMap<" + def.getAsClass() + ", " + def.getActivationClass() + ">());");
            }
            this.writeEol(out);
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConfigProps(def, out, indent);
        this.writeEndpointLifecycle(def, out, indent);
        this.writeLifecycle(def, out, indent);
        this.writeXAResource(def, out, indent);
        this.writeHashCode(def, out, indent);
        this.writeEquals(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isSupportInbound()) {
            out.write("import " + def.getRaPackage() + ".inflow." + def.getActivationClass() + ";");
            this.writeEol(out);
            out.write("import " + def.getRaPackage() + ".inflow." + def.getAsClass() + ";");
            this.writeEol(out);
            this.writeEol(out);
            if (def.getVersion().equals("1.5")) {
                out.write("import java.util.Collections;");
                this.writeEol(out);
                out.write("import java.util.HashMap;");
                this.writeEol(out);
                out.write("import java.util.Map;");
                this.writeEol(out);
                this.writeEol(out);
            } else if (def.getVersion().equals("1.6")) {
                out.write("import java.util.concurrent.ConcurrentHashMap;");
                this.writeEol(out);
                this.writeEol(out);
            }
        }
        out.write("import java.util.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ActivationSpec;");
        this.writeEol(out);
        if (def.isUseAnnotation() && def.getAuthenMechanisms() != null && def.getAuthenMechanisms().size() > 0) {
            out.write("import javax.resource.spi.AuthenticationMechanism;");
            this.writeEol(out);
            out.write("import javax.resource.spi.AuthenticationMechanism.CredentialInterface;");
            this.writeEol(out);
        }
        out.write("import javax.resource.spi.BootstrapContext;");
        this.writeEol(out);
        if (def.isUseAnnotation()) {
            out.write("import javax.resource.spi.ConfigProperty;");
            this.writeEol(out);
            out.write("import javax.resource.spi.Connector;");
            this.writeEol(out);
        }
        out.write("import javax.resource.spi.ResourceAdapter;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ResourceAdapterInternalException;");
        this.writeEol(out);
        if (def.isUseAnnotation() && def.getSecurityPermissions() != null && def.getSecurityPermissions().size() > 0) {
            out.write("import javax.resource.spi.SecurityPermission;");
            this.writeEol(out);
        }
        if (def.isUseAnnotation() && def.isSupportOutbound()) {
            out.write("import javax.resource.spi.TransactionSupport;");
            this.writeEol(out);
        }
        out.write("import javax.resource.spi.endpoint.MessageEndpointFactory;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.transaction.xa.XAResource;");
        this.writeEol(out);
        this.writeEol(out);
    }

    private void writeXAResource(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This method is called by the application server during crash recovery.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param specs An array of ActivationSpec JavaBeans ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return An array of XAResource objects");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public XAResource[] getXAResources(ActivationSpec[] specs)");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"getXAResources()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This is called when a resource adapter instance is bootstrapped.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param ctx A bootstrap context containing references ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceAdapterInternalException indicates bootstrap failure.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void start(BootstrapContext ctx)");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("throws ResourceAdapterInternalException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"start()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This is called when a resource adapter instance is undeployed or");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * during application server shutdown. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void stop()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"stop()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeEndpointLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This is called during the activation of a message endpoint.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param endpointFactory A message endpoint factory instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param spec An activation spec JavaBean instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void endpointActivation(MessageEndpointFactory endpointFactory,");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("ActivationSpec spec) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isSupportInbound()) {
            this.writeIndent(out, indent + 1);
            out.write(def.getActivationClass() + " activation = new " + def.getActivationClass() + "(this, endpointFactory, (" + def.getAsClass() + ")spec);");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("activations.put((" + def.getAsClass() + ")spec, activation);");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("activation.start();");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"endpointActivation()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This is called when a message endpoint is deactivated. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param endpointFactory A message endpoint factory instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param spec An activation spec JavaBean instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void endpointDeactivation(MessageEndpointFactory endpointFactory,");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("ActivationSpec spec)");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isSupportInbound()) {
            this.writeIndent(out, indent + 1);
            out.write(def.getActivationClass() + " activation = activations.remove(spec);");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("if (activation != null)");
            this.writeEol(out);
            this.writeIndent(out, indent + 2);
            out.write("activation.stop();");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"endpointDeactivation()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getRaClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getRaConfigProps();
    }
}

