/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class CciConnCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements Connection");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeDefaultConstructor(def, out, indent);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param connSpec ConnectionSpec");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "(ConnectionSpec connSpec)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeClose(def, out, indent);
        this.writeInteraction(def, out, indent);
        this.writeLocalTransaction(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeResultSetInfo(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.cci.Connection;");
        this.writeEol(out);
        out.write("import javax.resource.cci.ConnectionMetaData;");
        this.writeEol(out);
        out.write("import javax.resource.cci.ConnectionSpec;");
        this.writeEol(out);
        out.write("import javax.resource.cci.Interaction;");
        this.writeEol(out);
        out.write("import javax.resource.cci.LocalTransaction;");
        this.writeEol(out);
        out.write("import javax.resource.cci.ResultSetInfo;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getCciConnClass();
    }

    private void writeClose(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Initiates close of the connection handle at the application level.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Exception thrown if close on a connection handle fails.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void close() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeInteraction(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Creates an Interaction associated with this Connection. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Interaction instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to create an Interaction");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Interaction createInteraction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLocalTransaction(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns an LocalTransaction instance that enables a component to ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * demarcate resource manager local transactions on the Connection.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return LocalTransaction instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to return a LocalTransaction");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws javax.resource.NotSupportedException Demarcation of Resource manager ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public LocalTransaction getLocalTransaction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets the information on the underlying EIS instance represented through an active connection.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return ConnectionMetaData instance representing information about the EIS instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to get information about the connected EIS instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ConnectionMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return new " + def.getConnMetaClass() + "();");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResultSetInfo(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets the information on the ResultSet functionality supported by ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * a connected EIS instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return ResultSetInfo instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Failed to get ResultSet related information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws javax.resource.NotSupportedException ResultSet functionality is not supported");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ResultSetInfo getResultSetInfo() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

