/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class McCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public class " + this.getClassName(def) + " implements ManagedConnection");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(\"" + this.getClassName(def) + "\");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The logwriter */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private PrintWriter logwriter;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConnection(def, out, indent);
        this.writeLifecycle(def, out, indent);
        this.writeConnectionEventListener(def, out, indent);
        this.writeLogWriter(def, out, indent);
        this.writeTransaction(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.io.PrintWriter;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.util.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionEventListener;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionRequestInfo;");
        this.writeEol(out);
        out.write("import javax.resource.spi.LocalTransaction;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnection;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnectionMetaData;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.security.auth.Subject;");
        this.writeEol(out);
        out.write("import javax.transaction.xa.XAResource;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Creates a new connection handle for the underlying physical connection ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * represented by the ManagedConnection instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param subject Security context as JAAS subject");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param cxRequestInfo ConnectionRequestInfo instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return generic Object instance representing the connection handle. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Object getConnection(Subject subject,");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"getConnection()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Used by the container to change the association of an ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * application-level connection handle with a ManagedConneciton instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param connection Application-level connection handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void associateConnection(Object connection) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"associateConnection()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Application server calls this method to force any cleanup on the ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void cleanup() throws ResourceException");
        this.writeEol(out);
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"cleanup()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Destroys the physical connection to the underlying resource manager.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void destroy() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"destroy()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeConnectionEventListener(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Adds a connection event listener to the ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param listener A new ConnectionEventListener to be registered");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void addConnectionEventListener(ConnectionEventListener listener)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"addConnectionEventListener()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Removes an already registered connection event listener from the ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param listener already registered connection event listener to be removed");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void removeConnectionEventListener(ConnectionEventListener listener)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"removeConnectionEventListener()\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLogWriter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets the log writer for this ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Character ourput stream associated with this Managed-Connection instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public PrintWriter getLogWriter() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"getLogWriter()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return logwriter;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Sets the log writer for this ManagedConnection instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param out Character Output stream to be associated");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException  generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setLogWriter(PrintWriter out) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"setLogWriter()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("logwriter = out;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeTransaction(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns an <code>javax.resource.spi.LocalTransaction</code> instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return LocalTransaction instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public LocalTransaction getLocalTransaction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"getLocalTransaction()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns an <code>javax.transaction.xa.XAresource</code> instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return XAResource instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public XAResource getXAResource() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"getXAResource()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Gets the metadata information for this connection's underlying EIS resource manager instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return ManagedConnectionMetaData instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException generic exception if operation fails");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ManagedConnectionMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.finest(\"getMetaData()\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return new " + def.getMcMetaClass() + "();");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

