/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class ConnMetaCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ConnectionMetaData");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeDefaultConstructor(def, out, indent);
        this.writeEIS(def, out, indent);
        this.writeUsername(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.cci.ConnectionMetaData;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getConnMetaClass();
    }

    private void writeEIS(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns product name of the underlying EIS instance connected");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Product name of the EIS instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException  Failed to get the information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public String getEISProductName() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns product version of the underlying EIS instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Product version of the EIS instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException  Failed to get the information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public String getEISProductVersion() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeUsername(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns the user name for an active connection as known to the underlying EIS instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return String representing the user name");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException  Failed to get the information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public String getUserName() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

