/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class ConnInterfaceCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public interface " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        if (def.isDefineMethodInConnection()) {
            if (def.getMethods().size() > 0) {
                for (MethodForConnection method : def.getMethods()) {
                    this.writeIndent(out, indent);
                    out.write("/**");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" * " + method.getMethodName());
                    this.writeEol(out);
                    for (MethodParam param : method.getParams()) {
                        this.writeIndent(out, indent);
                        out.write(" * @param " + param.getName() + " " + param.getName());
                        this.writeEol(out);
                    }
                    if (!method.getReturnType().equals("void")) {
                        this.writeIndent(out, indent);
                        out.write(" * @return " + method.getReturnType());
                        this.writeEol(out);
                    }
                    for (String ex : method.getExceptionType()) {
                        this.writeIndent(out, indent);
                        out.write(" * @throws " + ex + " " + ex);
                        this.writeEol(out);
                    }
                    this.writeIndent(out, indent);
                    out.write(" */");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write("public " + method.getReturnType() + " " + method.getMethodName() + "(");
                    int paramSize = method.getParams().size();
                    for (int i = 0; i < paramSize; ++i) {
                        MethodParam param = method.getParams().get(i);
                        out.write(param.getType());
                        out.write(" ");
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(")");
                    int exceptionSize = method.getExceptionType().size();
                    for (int i = 0; i < exceptionSize; ++i) {
                        if (i == 0) {
                            out.write(" throws ");
                        }
                        String ex = method.getExceptionType().get(i);
                        out.write(ex);
                        if (i + 1 >= exceptionSize) continue;
                        out.write(", ");
                    }
                    out.write(";");
                    this.writeEol(out);
                }
            }
        } else {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * call me");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void callMe();");
        }
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getConnInterfaceClass();
    }
}

