/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public abstract class PropsCodeGen
extends AbstractCodeGen {
    void writeConfigProps(Definition def, Writer out, int indent) throws IOException {
        int i;
        if (this.getConfigProps(def) == null) {
            return;
        }
        for (i = 0; i < this.getConfigProps(def).size(); ++i) {
            this.writeIndent(out, indent);
            out.write("/** " + this.getConfigProps(def).get(i).getName() + " */");
            this.writeEol(out);
            if (def.isUseAnnotation()) {
                this.writeIndent(out, indent);
                out.write("@ConfigProperty(defaultValue=\"" + this.getConfigProps(def).get(i).getValue() + "\")");
                this.writeEol(out);
            }
            this.writeIndent(out, indent);
            out.write("private " + this.getConfigProps(def).get(i).getType() + " " + this.getConfigProps(def).get(i).getName() + ";");
            this.writeEol(out);
            this.writeEol(out);
        }
        for (i = 0; i < this.getConfigProps(def).size(); ++i) {
            String name = this.getConfigProps(def).get(i).getName();
            String upcaseName = this.upcaseFirst(name);
            this.writeIndent(out, indent);
            out.write("/** ");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * set " + name);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @param " + name + " The value");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void set" + upcaseName + "(" + this.getConfigProps(def).get(i).getType() + " " + name + ")");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("this." + name + " = " + name + ";");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("/** ");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * get " + name);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @return The value");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public " + this.getConfigProps(def).get(i).getType() + " get" + upcaseName + "()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("return " + name + ";");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
        }
    }

    @Override
    void writeHashCode(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns a hash code value for the object.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return a hash code value for this object.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public int hashCode()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("int result = 17;");
        this.writeEol(out);
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            this.writeIndent(out, indent + 1);
            out.write("if (" + this.getConfigProps(def).get(i).getName() + " != null)");
            this.writeEol(out);
            this.writeIndent(out, indent + 2);
            out.write("result += 31 * result + 7 * " + this.getConfigProps(def).get(i).getName() + ".hashCode();");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("else");
            this.writeEol(out);
            this.writeIndent(out, indent + 2);
            out.write("result += 31 * result + 7;");
            this.writeEol(out);
        }
        this.writeIndent(out, indent + 1);
        out.write("return result;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    @Override
    void writeEquals(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Indicates whether some other object is equal to this one.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   other   the reference object with which to compare.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return true if this object is the same as the obj argument; false otherwise.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public boolean equals(Object other)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("if (other == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("return false;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("if (other == this)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("return true;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("if (!(other instanceof " + this.getClassName(def) + "))");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("return false;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write(this.getClassName(def) + " obj = (" + this.getClassName(def) + ")other;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("boolean result = true; ");
        this.writeEol(out);
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            this.writeIndent(out, indent + 1);
            out.write("if (result)");
            this.writeLeftCurlyBracket(out, indent + 1);
            this.writeIndent(out, indent + 2);
            out.write("if (" + this.getConfigProps(def).get(i).getName() + " == null)");
            this.writeEol(out);
            this.writeIndent(out, indent + 3);
            out.write("result = obj.get" + this.upcaseFirst(this.getConfigProps(def).get(i).getName()) + "() == null;");
            this.writeEol(out);
            this.writeIndent(out, indent + 2);
            out.write("else");
            this.writeEol(out);
            this.writeIndent(out, indent + 3);
            out.write("result = " + this.getConfigProps(def).get(i).getName() + ".equals(obj.get" + this.upcaseFirst(this.getConfigProps(def).get(i).getName()) + "());");
            this.writeRightCurlyBracket(out, indent + 1);
        }
        this.writeIndent(out, indent + 1);
        out.write("return result;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    public abstract List<ConfigPropType> getConfigProps(Definition var1);
}

