/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class CfInterfaceCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public interface " + this.getClassName(def) + " extends Serializable, Referenceable");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeConnection(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.io.Serializable;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.Referenceable;");
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getCfInterfaceClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * get connection from factory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return " + def.getConnInterfaceClass() + " instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception ResourceException Thrown if a connection can't be obtained");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + def.getConnInterfaceClass() + " getConnection() throws ResourceException;");
        this.writeEol(out);
    }
}

