/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.as.converters.XaDataSource;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.DsXaPoolImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;

public class LegacyXaDataSourceImp
implements XaDataSource {
    private XADataSourceImpl dsImpl = null;
    private String xaDataSourceClass;
    private final String driver;
    private final HashMap<String, String> xaDataSourceProperty;
    private final TransactionIsolation transactionIsolation;
    private TimeOut timeOut = null;
    private DsSecurity security = null;
    private Statement statement = null;
    private Validation validation = null;
    private DsXaPool xaPool = null;
    private String urlDelimiter;
    private String urlSelectorStrategyClassName;
    private String newConnectionSql;
    private Boolean useJavaContext;
    private String poolName;
    private Boolean enabled;
    private String jndiName;
    private Boolean spy;
    private Boolean useCcm;
    private Boolean jta;
    private Recovery recovery;
    private Boolean isSameRmOverride;
    private Boolean interleaving;
    private Boolean padXid;
    private Boolean wrapXaDataSource;
    private Boolean noTxSeparatePool;

    public LegacyXaDataSourceImp(String xaDataSourceClass, String driver, TransactionIsolation transactionIsolation, Map<String, String> xaDataSourceProperty) {
        this.xaDataSourceClass = xaDataSourceClass;
        this.driver = driver;
        if (xaDataSourceProperty != null) {
            this.xaDataSourceProperty = new HashMap(xaDataSourceProperty.size());
            this.xaDataSourceProperty.putAll(xaDataSourceProperty);
        } else {
            this.xaDataSourceProperty = new HashMap(0);
        }
        this.transactionIsolation = transactionIsolation;
    }

    public void buildXaDataSourceImpl() throws Exception {
        this.dsImpl = new XADataSourceImpl(this.transactionIsolation, this.timeOut, this.security, this.statement, this.validation, this.urlDelimiter, "|", this.urlSelectorStrategyClassName, this.useJavaContext, this.poolName, this.enabled, this.jndiName, this.spy, this.useCcm, Defaults.CONNECTABLE, Defaults.TRACKING, Defaults.MCP, Defaults.ENLISTMENT_TRACE, this.xaDataSourceProperty, this.xaDataSourceClass, this.driver, this.newConnectionSql, this.xaPool, this.recovery);
    }

    public String toString() {
        String out = this.dsImpl.toString();
        return out;
    }

    public LegacyXaDataSourceImp buildTimeOut(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout, Boolean setTxQueryTimeout, Long queryTimeout, Long useTryLock) throws Exception {
        this.timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQueryTimeout, queryTimeout, useTryLock);
        return this;
    }

    public LegacyXaDataSourceImp buildDsSecurity(String userName, String password, String securityDomain, Extension reauthPlugin) throws Exception {
        this.security = new DsSecurityImpl(userName, password, securityDomain, reauthPlugin);
        return this;
    }

    public LegacyXaDataSourceImp buildStatement(Boolean sharePreparedStatements, Long preparedStatementsCacheSize, Statement.TrackStatementsEnum trackStatements) throws Exception {
        this.statement = new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
        return this;
    }

    public LegacyXaDataSourceImp buildValidation(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail, Extension validConnectionChecker, String checkValidConnectionSql, Boolean validateOnMatch, Extension staleConnectionChecker, Extension exceptionSorter) throws Exception {
        this.validation = new ValidationImpl(backgroundValidation, backgroundValidationMillis, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
        return this;
    }

    public LegacyXaDataSourceImp buildCommonPool(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Boolean isSameRmOverride, Boolean interleaving, Boolean padXid, Boolean wrapXaResource, Boolean noTxSeparatePool) throws Exception {
        this.xaPool = new DsXaPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaResource, noTxSeparatePool, Boolean.valueOf(false), null, null, null);
        return this;
    }

    public LegacyXaDataSourceImp buildRecovery(String recoveryUsername, String recoveryPassword, Boolean noRecovery) throws Exception {
        if (recoveryUsername == null || recoveryUsername.equals("")) {
            recoveryUsername = "user";
        }
        if (recoveryPassword == null || recoveryPassword.equals("")) {
            recoveryPassword = "password";
        }
        this.recovery = new Recovery((Credential)new CredentialImpl(recoveryUsername, recoveryPassword, null), null, noRecovery);
        return this;
    }

    public LegacyXaDataSourceImp buildOther(String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useCcm, Boolean jta) {
        this.urlDelimiter = urlDelimiter;
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
        this.newConnectionSql = newConnectionSql;
        this.useJavaContext = useJavaContext;
        this.poolName = poolName;
        this.enabled = enabled;
        this.jndiName = jndiName;
        this.spy = spy;
        this.useCcm = useCcm;
        this.setJta(jta);
        return this;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    @Override
    public String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    @Override
    public String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    @Override
    public String getUserName() {
        return this.security.getUserName();
    }

    @Override
    public String getPassword() {
        return this.security.getPassword();
    }

    @Override
    public String getSecurityDomain() {
        return null;
    }

    @Override
    public Integer getMinPoolSize() {
        return this.xaPool.getMinPoolSize();
    }

    @Override
    public Integer getMaxPoolSize() {
        return this.xaPool.getMaxPoolSize();
    }

    @Override
    public Long getBlockingTimeoutMillis() {
        return this.timeOut.getBlockingTimeoutMillis();
    }

    @Override
    public Boolean isBackgroundValidation() {
        return this.validation.isBackgroundValidation();
    }

    @Override
    public Long getBackgroundValidationMillis() {
        return this.validation.getBackgroundValidationMillis();
    }

    @Override
    public Long getIdleTimeoutMinutes() {
        return this.timeOut.getIdleTimeoutMinutes();
    }

    @Override
    public Integer getAllocationRetry() {
        return this.timeOut.getAllocationRetry();
    }

    @Override
    public Long getAllocationRetryWaitMillis() {
        return this.timeOut.getAllocationRetryWaitMillis();
    }

    @Override
    public Boolean isValidateOnMatch() {
        return this.validation.isValidateOnMatch();
    }

    @Override
    public String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    @Override
    public String getCheckValidConnectionSql() {
        return this.validation.getCheckValidConnectionSql();
    }

    @Override
    public Extension getValidConnectionChecker() {
        return this.validation.getValidConnectionChecker();
    }

    @Override
    public Extension getExceptionSorter() {
        return null;
    }

    @Override
    public Extension getStaleConnectionChecker() {
        return null;
    }

    @Override
    public Statement.TrackStatementsEnum getTrackStatements() {
        return this.statement.getTrackStatements();
    }

    @Override
    public Boolean isPrefill() {
        return this.xaPool.isPrefill();
    }

    @Override
    public Boolean isUseFastFail() {
        return this.validation.isUseFastFail();
    }

    @Override
    public Long getPreparedStatementsCacheSize() {
        return this.statement.getPreparedStatementsCacheSize();
    }

    @Override
    public Boolean isSharePreparedStatements() {
        return this.statement.isSharePreparedStatements();
    }

    @Override
    public Boolean isSetTxQueryTimeout() {
        return this.timeOut.isSetTxQueryTimeout();
    }

    @Override
    public Long getQueryTimeout() {
        return this.timeOut.getQueryTimeout();
    }

    @Override
    public Long getUseTryLock() {
        return this.timeOut.getUseTryLock();
    }

    @Override
    public Boolean isNoTxSeparatePools() {
        return this.noTxSeparatePool;
    }

    @Override
    public Boolean isTrackConnectionByTx() {
        return false;
    }

    @Override
    public Integer getXaResourceTimeout() {
        return this.timeOut.getXaResourceTimeout();
    }

    @Override
    public String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    @Override
    public Map<String, String> getXaDataSourceProperty() {
        return this.xaDataSourceProperty;
    }

    @Override
    public Boolean isSameRmOverride() {
        return this.isSameRmOverride;
    }

    @Override
    public Boolean isInterleaving() {
        return this.interleaving;
    }

    @Override
    public Boolean isPadXid() {
        return this.padXid;
    }

    @Override
    public Boolean isWrapXaResource() {
        return this.wrapXaDataSource;
    }

    public void setJta(Boolean jta) {
        this.jta = jta;
    }

    public Boolean getJta() {
        return this.jta;
    }
}

