/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.as.converters.AbstractParser;
import org.jboss.jca.as.converters.DataSource;
import org.jboss.jca.as.converters.DataSources;
import org.jboss.jca.as.converters.DatasourcesImpl;
import org.jboss.jca.as.converters.LegacyTxDataSourceImpl;
import org.jboss.jca.as.converters.LegacyXaDataSourceImp;
import org.jboss.jca.as.converters.LocalTxDataSource;
import org.jboss.jca.as.converters.NoTxDataSource;
import org.jboss.jca.as.converters.ParserException;
import org.jboss.jca.as.converters.UnknownTagException;
import org.jboss.jca.as.converters.XaDataSource;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.logging.Logger;

public class LegacyDsParser
extends AbstractParser {
    private static Logger log = Logger.getLogger(LegacyDsParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSources parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            DataSources dataSources = this.parse(reader);
            return dataSources;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void skipParse(XMLStreamReader reader) throws Exception {
        int level = 1;
        block4: while (reader.hasNext() && level > 0) {
            switch (reader.next()) {
                case 2: {
                    --level;
                    continue block4;
                }
                case 1: {
                    ++level;
                    continue block4;
                }
            }
        }
        log.info((Object)("Skipping: " + reader.getLocalName()));
    }

    private void notSupport(XMLStreamReader reader) throws Exception {
        log.info((Object)("So far not support " + reader.getLocalName()));
    }

    private DataSources parse(XMLStreamReader reader) throws Exception {
        int iterate;
        DataSources dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        dataSources = this.parseDataSources(reader);
                        break block1;
                    }
                    case CONNECTION_FACTORIES: {
                        this.notSupport(reader);
                        return null;
                    }
                }
                throw new UnknownTagException(reader.getLocalName());
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dataSources;
    }

    private DataSources parseDataSources(XMLStreamReader reader) throws Exception {
        ArrayList<NoTxDataSource> noTxDatasource = new ArrayList<NoTxDataSource>();
        ArrayList<LocalTxDataSource> localTxDatasource = new ArrayList<LocalTxDataSource>();
        ArrayList<XaDataSource> xaDataSource = new ArrayList<XaDataSource>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return new DatasourcesImpl(noTxDatasource, localTxDatasource, xaDataSource);
                    }
                    if (DataSources.Tag.forName(reader.getLocalName()) != DataSources.Tag.UNKNOWN) break;
                    throw new UnknownTagException(reader.getLocalName());
                }
                case 1: {
                    switch (DataSources.Tag.forName(reader.getLocalName())) {
                        case NO_TX_DATASOURCE: {
                            noTxDatasource.add(this.parseLocalTxDataSource(reader));
                            break block0;
                        }
                        case LOCAL_TX_DATASOURCE: {
                            localTxDatasource.add(this.parseLocalTxDataSource(reader));
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            xaDataSource.add(this.parseXADataSource(reader));
                            break block0;
                        }
                    }
                    this.skipParse(reader);
                }
            }
        }
        throw new ParserException(reader.getLocalName());
    }

    private XaDataSource parseXADataSource(XMLStreamReader reader) throws Exception {
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        String driver = "";
        String xaDataSourceClass = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        String userName = null;
        String password = null;
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        Boolean prefill = Defaults.PREFILL;
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        Boolean setTxQueryTimeout = Defaults.SET_TX_QUERY_TIMEOUT;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = null;
        Long preparedStatementsCacheSize = null;
        Boolean sharePreparedStatements = Defaults.SHARE_PREPARED_STATEMENTS;
        Statement.TrackStatementsEnum trackStatements = Statement.TrackStatementsEnum.FALSE;
        TransactionIsolation transactionIsolation = TransactionIsolation.TRANSACTION_NONE;
        String securityDomain = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        Long backgroundValidationMillis = null;
        Boolean useFastFail = Defaults.USE_FAST_FAIL;
        Extension validConnectionChecker = null;
        String checkValidConnectionSql = null;
        Boolean validateOnMatch = Defaults.VALIDATE_ON_MATCH;
        Extension staleConnectionChecker = null;
        Extension exceptionSorter = null;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean interleaving = Defaults.INTERLEAVING;
        Boolean padXid = Defaults.PAD_XID;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        String recoveryUsername = null;
        String recoveryPassword = null;
        Boolean noRecovery = Defaults.NO_RECOVERY;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName(reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        LegacyXaDataSourceImp xaDsImpl = new LegacyXaDataSourceImp(xaDataSourceClass, driver, transactionIsolation, xaDataSourceProperty);
                        xaDsImpl.buildTimeOut(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQueryTimeout, queryTimeout, useTryLock);
                        xaDsImpl.buildDsSecurity(userName, password, securityDomain, null);
                        xaDsImpl.buildStatement(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
                        xaDsImpl.buildValidation(backgroundValidation, backgroundValidationMillis, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
                        xaDsImpl.buildCommonPool(minPoolSize, minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool);
                        xaDsImpl.buildRecovery(recoveryUsername, recoveryPassword, noRecovery);
                        xaDsImpl.buildOther(urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta);
                        xaDsImpl.buildXaDataSourceImpl();
                        return xaDsImpl;
                    }
                    if (XaDataSource.Tag.forName(reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new UnknownTagException(reader.getLocalName());
                }
                case 1: {
                    switch (XaDataSource.Tag.forName(reader.getLocalName())) {
                        case SECURITY_DOMAIN: 
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomain = this.elementAsString(reader);
                            userName = null;
                            break block0;
                        }
                        case XA_DATASOURCE_PROPERTY: {
                            xaDataSourceProperty.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block0;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block0;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block0;
                        }
                        case TRANSACTION_ISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            isSameRmOverride = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case TRACK_CONNECTION_BY_TX: {
                            interleaving = false;
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            String classname = this.elementAsString(reader);
                            validConnectionChecker = new Extension(classname, null, null);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            String classname = this.elementAsString(reader);
                            exceptionSorter = new Extension(classname, null, null);
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            String classname = this.elementAsString(reader);
                            staleConnectionChecker = new Extension(classname, null, null);
                            break block0;
                        }
                        case JNDI_NAME: {
                            poolName = this.elementAsString(reader);
                            if (poolName.startsWith("java:")) {
                                poolName = poolName.substring(5);
                            }
                            jndiName = "java:jboss/datasources/" + poolName;
                            break block0;
                        }
                        case USE_JAVA_CONTEXT: {
                            useJavaContext = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USER_NAME: {
                            if (securityDomain != null) break block0;
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            queryTimeout = this.elementAsLong(reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            setTxQueryTimeout = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            useTryLock = this.elementAsLong(reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            preparedStatementsCacheSize = this.elementAsLong(reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            trackStatements = Statement.TrackStatementsEnum.TRUE;
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            sharePreparedStatements = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            checkValidConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            validateOnMatch = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case RECOVER_USER_NAME: {
                            recoveryUsername = this.elementAsString(reader);
                            break block0;
                        }
                        case RECOVER_PASSWORD: {
                            recoveryPassword = this.elementAsString(reader);
                            break block0;
                        }
                        case NO_RECOVER: {
                            noRecovery = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    this.skipParse(reader);
                    break;
                }
            }
        }
        throw new ParserException();
    }

    private LocalTxDataSource parseLocalTxDataSource(XMLStreamReader reader) throws Exception {
        String connectionUrl = null;
        String driverClass = null;
        String dataSourceClass = "";
        String driver = "";
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        String userName = null;
        String password = null;
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        Boolean prefill = Defaults.PREFILL;
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = 0;
        Long preparedStatementsCacheSize = null;
        Boolean sharePreparedStatements = Defaults.SHARE_PREPARED_STATEMENTS;
        Statement.TrackStatementsEnum trackStatements = Statement.TrackStatementsEnum.FALSE;
        Boolean setTxQueryTimeout = Defaults.SET_TX_QUERY_TIMEOUT;
        TransactionIsolation transactionIsolation = TransactionIsolation.TRANSACTION_NONE;
        String securityDomain = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        Long backgroundValidationMillis = null;
        Boolean useFastFail = Defaults.USE_FAST_FAIL;
        Extension validConnectionChecker = null;
        String checkValidConnectionSql = null;
        Boolean validateOnMatch = Defaults.VALIDATE_ON_MATCH;
        Extension staleConnectionChecker = null;
        Extension exceptionSorter = null;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName(reader.getLocalName()) == DataSources.Tag.LOCAL_TX_DATASOURCE) {
                        LegacyTxDataSourceImpl txDsImpl = new LegacyTxDataSourceImpl(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties);
                        txDsImpl.buildTimeOut(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQueryTimeout, queryTimeout, useTryLock);
                        txDsImpl.buildDsSecurity(userName, password, securityDomain, null);
                        txDsImpl.buildStatement(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
                        txDsImpl.buildValidation(backgroundValidation, backgroundValidationMillis, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
                        txDsImpl.buildCommonPool(minPoolSize, minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy);
                        txDsImpl.buildOther(urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta);
                        txDsImpl.buildDataSourceImpl();
                        return txDsImpl;
                    }
                    if (DataSource.Tag.forName(reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new UnknownTagException(reader.getLocalName());
                }
                case 1: {
                    switch (LocalTxDataSource.Tag.forName(reader.getLocalName())) {
                        case VALID_CONNECTION_CHECKER: {
                            String classname = this.elementAsString(reader);
                            validConnectionChecker = new Extension(classname, null, null);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            String classname = this.elementAsString(reader);
                            exceptionSorter = new Extension(classname, null, null);
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            String classname = this.elementAsString(reader);
                            staleConnectionChecker = new Extension(classname, null, null);
                            break block0;
                        }
                        case SECURITY_DOMAIN: 
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomain = this.elementAsString(reader);
                            userName = null;
                            break block0;
                        }
                        case CONNECTION_PROPERTY: {
                            connectionProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case CONNECTION_URL: {
                            connectionUrl = this.elementAsString(reader);
                            break block0;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block0;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block0;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block0;
                        }
                        case TRANSACTION_ISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block0;
                        }
                        case JNDI_NAME: {
                            poolName = this.elementAsString(reader);
                            if (poolName.startsWith("java:")) {
                                poolName = poolName.substring(5);
                            }
                            jndiName = "java:jboss/datasources/" + poolName;
                            break block0;
                        }
                        case USE_JAVA_CONTEXT: {
                            useJavaContext = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USER_NAME: {
                            if (securityDomain != null) break block0;
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            queryTimeout = this.elementAsLong(reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            setTxQueryTimeout = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            useTryLock = this.elementAsLong(reader);
                            break block0;
                        }
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            preparedStatementsCacheSize = this.elementAsLong(reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            trackStatements = Statement.TrackStatementsEnum.TRUE;
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            sharePreparedStatements = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            checkValidConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            validateOnMatch = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    this.skipParse(reader);
                }
            }
        }
        throw new ParserException();
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources"),
        CONNECTION_FACTORIES("connection-factories");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

