/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.as.converters.TxConnectionFactory;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.common.SecurityImpl;
import org.jboss.jca.common.metadata.common.TimeOutImpl;
import org.jboss.jca.common.metadata.common.ValidationImpl;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.jca.common.metadata.resourceadapter.AdminObjectImpl;
import org.jboss.jca.common.metadata.resourceadapter.ConnectionDefinitionImpl;

public class LegacyConnectionFactoryImp
implements TxConnectionFactory {
    private ActivationImpl raImpl = null;
    private TransactionSupportEnum transactionSupport;
    private List<ConnectionDefinition> connectionDefinitions;
    private List<AdminObject> adminObjects;
    private TimeOutImpl timeOut = null;
    private SecurityImpl security = null;
    private ValidationImpl validation = null;
    private Pool pool = null;
    private WorkManager workmanager = null;
    private String jndiName;
    private String rarName;
    private String poolName;
    private String connectionDefinition;
    private Map<String, String> rarConfigProperty;
    private Map<String, String> connConfigProperty;
    private Boolean noTxSeparatePool;
    private Boolean interleaving;

    public LegacyConnectionFactoryImp(String jndiName, String rarName, Map<String, String> rarConfigProperty, String poolName, String connectionDefinition, Map<String, String> connConfigProperty, TransactionSupportEnum transactionSupport) {
        this.jndiName = jndiName;
        this.rarName = rarName;
        this.poolName = poolName;
        if (rarConfigProperty != null) {
            this.rarConfigProperty = new HashMap<String, String>(rarConfigProperty.size());
            this.rarConfigProperty.putAll(rarConfigProperty);
        } else {
            this.rarConfigProperty = new HashMap<String, String>(0);
        }
        if (connConfigProperty != null) {
            this.connConfigProperty = new HashMap<String, String>(connConfigProperty.size());
            this.connConfigProperty.putAll(connConfigProperty);
        } else {
            this.connConfigProperty = new HashMap<String, String>(0);
        }
        this.connectionDefinition = connectionDefinition;
        this.transactionSupport = transactionSupport;
    }

    public void buildResourceAdapterImpl() throws Exception {
        Boolean isXA = Boolean.FALSE;
        Recovery recovery = null;
        if (this.transactionSupport.equals((Object)TransactionSupportEnum.XATransaction)) {
            isXA = Boolean.TRUE;
            recovery = new Recovery((Credential)new CredentialImpl("user", "password", null), null, Boolean.valueOf(false));
        }
        ConnectionDefinitionImpl connDef = new ConnectionDefinitionImpl(this.connConfigProperty, "FIXME", this.jndiName, this.poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, Defaults.SHARABLE, Defaults.ENLISTMENT, Defaults.CONNECTABLE, Defaults.TRACKING, Defaults.MCP, Defaults.ENLISTMENT_TRACE, this.pool, (TimeOut)this.timeOut, (Validation)this.validation, (Security)this.security, recovery, isXA);
        this.connectionDefinitions = new ArrayList<ConnectionDefinition>();
        this.connectionDefinitions.add((ConnectionDefinition)connDef);
        this.raImpl = new ActivationImpl("ID", this.rarName, this.transactionSupport, this.connectionDefinitions, this.adminObjects, this.rarConfigProperty, null, null, this.workmanager);
    }

    public String toString() {
        String out = this.raImpl.toString();
        return out;
    }

    public LegacyConnectionFactoryImp buildTimeOut(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout) throws Exception {
        this.timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        return this;
    }

    public LegacyConnectionFactoryImp buildValidation(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail) throws Exception {
        this.validation = new ValidationImpl(Boolean.FALSE, backgroundValidation, backgroundValidationMillis, useFastFail);
        return this;
    }

    public LegacyConnectionFactoryImp buildCommonPool(Integer minPoolSize, Integer maxPoolSize, Boolean prefill, Capacity capacity, Boolean noTxSeparatePool, Boolean interleaving) throws Exception {
        this.pool = this.transactionSupport == TransactionSupportEnum.XATransaction ? new XaPoolImpl(minPoolSize, null, maxPoolSize, prefill, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, capacity, Defaults.FAIR, Defaults.IS_SAME_RM_OVERRIDE, interleaving, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, noTxSeparatePool) : new PoolImpl(minPoolSize, null, maxPoolSize, prefill, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, capacity, Defaults.FAIR);
        this.noTxSeparatePool = noTxSeparatePool;
        this.setInterleaving(interleaving);
        return this;
    }

    public LegacyConnectionFactoryImp buildSecurity(String securityDomainManaged, String securityDomainAndApplicationManaged, boolean applicationManaged) throws Exception {
        this.security = new SecurityImpl(securityDomainManaged, securityDomainAndApplicationManaged, applicationManaged);
        return this;
    }

    public LegacyConnectionFactoryImp buildAdminObejcts(String className, String jndiName, String poolName, Map<String, String> configProperties, boolean enabled, boolean useJavaContext) throws Exception {
        if (this.adminObjects == null) {
            this.adminObjects = new ArrayList<AdminObject>();
        }
        this.adminObjects.add((AdminObject)new AdminObjectImpl(configProperties, className, jndiName, poolName, Boolean.valueOf(enabled), Boolean.valueOf(useJavaContext)));
        return this;
    }

    public LegacyConnectionFactoryImp buildWorkManager(WorkManager workmanager) throws Exception {
        this.workmanager = workmanager;
        return this;
    }

    public LegacyConnectionFactoryImp buildOther() {
        return this;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getSecurityDomain() {
        return null;
    }

    @Override
    public Integer getMinPoolSize() {
        return this.pool.getMinPoolSize();
    }

    @Override
    public Integer getMaxPoolSize() {
        return this.pool.getMaxPoolSize();
    }

    @Override
    public Long getBlockingTimeoutMillis() {
        return this.timeOut.getBlockingTimeoutMillis();
    }

    @Override
    public Boolean isBackgroundValidation() {
        return this.validation.isBackgroundValidation();
    }

    @Override
    public Long getBackgroundValidationMillis() {
        return this.validation.getBackgroundValidationMillis();
    }

    @Override
    public Long getIdleTimeoutMinutes() {
        return this.timeOut.getIdleTimeoutMinutes();
    }

    @Override
    public Integer getAllocationRetry() {
        return this.timeOut.getAllocationRetry();
    }

    @Override
    public Long getAllocationRetryWaitMillis() {
        return this.timeOut.getAllocationRetryWaitMillis();
    }

    @Override
    public Boolean isPrefill() {
        return this.pool.isPrefill();
    }

    @Override
    public Boolean isUseFastFail() {
        return this.validation.isUseFastFail();
    }

    @Override
    public Boolean isNoTxSeparatePools() {
        return this.noTxSeparatePool;
    }

    @Override
    public Boolean isTrackConnectionByTx() {
        return false;
    }

    @Override
    public Integer getXaResourceTimeout() {
        return this.timeOut.getXaResourceTimeout();
    }

    @Override
    public String getRarName() {
        return this.rarName;
    }

    @Override
    public String getConnectionDefinition() {
        return this.connectionDefinition;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return this.rarConfigProperty;
    }

    @Override
    public TransactionSupportEnum getTransactionSupport() {
        return null;
    }

    public void setInterleaving(Boolean interleaving) {
        this.interleaving = interleaving;
    }

    public Boolean getInterleaving() {
        return this.interleaving;
    }
}

