/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.jca.as.tracer.SDeditGenerator;
import org.jboss.jca.as.tracer.TraceEventHelper;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class HTMLReport {
    private static void writeString(FileWriter fw, String s) throws Exception {
        for (int i = 0; i < s.length(); ++i) {
            fw.write(s.charAt(i));
        }
    }

    private static void writeEOL(FileWriter fw) throws Exception {
        fw.write(10);
    }

    private static void generateTopLevelIndexHTML(Map<String, TraceEventStatus> statuses, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>IronJacamar tracer report</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "Generated: " + new Date());
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Pool</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry<String, TraceEventStatus> entry : statuses.entrySet()) {
            String directory = entry.getKey();
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + directory + "/index.html\"><div style=\"color: ");
            HTMLReport.writeString(fw, entry.getValue().getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, directory);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generatePoolIndexHTML(String poolName, Map<String, TraceEventStatus> statuses, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Pool: " + poolName + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>ConnectionListeners</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry<String, TraceEventStatus> entry : statuses.entrySet()) {
            String directory = entry.getKey();
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + directory + "/index.html\"><div style=\"color: ");
            HTMLReport.writeString(fw, entry.getValue().getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, directory);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateConnectionListenerIndexHTML(String identifier, List<TraceEvent> data, String root, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>ConnectionListener: " + identifier + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Reports</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        Map<String, List<TraceEvent>> m = TraceEventHelper.split(data);
        for (Map.Entry<String, List<TraceEvent>> entry : m.entrySet()) {
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + entry.getKey() + "/index.html\"><div style=\"color: ");
            TraceEventStatus status = TraceEventHelper.getStatus(entry.getValue());
            HTMLReport.writeString(fw, status.getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, entry.getKey());
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
            OutputStreamWriter cl = null;
            try {
                File f = new File(root + "/" + entry.getKey());
                f.mkdirs();
                cl = new FileWriter(f.getAbsolutePath() + "/" + "index.html");
                HTMLReport.generateConnectionListenerReportHTML(f.getCanonicalPath(), identifier, entry.getValue(), (FileWriter)cl);
            }
            finally {
                if (cl != null) {
                    try {
                        cl.flush();
                        cl.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (status != TraceEventStatus.GREEN && status != TraceEventStatus.YELLOW) continue;
            OutputStreamWriter sdedit = null;
            try {
                File f = new File(root + "/" + entry.getKey());
                f.mkdirs();
                sdedit = new FileWriter(f.getAbsolutePath() + "/" + identifier + ".sdx");
                SDeditGenerator.generateSDedit(entry.getValue(), (FileWriter)sdedit);
            }
            finally {
                if (sdedit == null) continue;
                try {
                    sdedit.flush();
                    sdedit.close();
                }
                catch (Exception e) {}
            }
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateConnectionListenerReportHTML(String root, String identifier, List<TraceEvent> data, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>ConnectionListener: " + identifier + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>From:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>" + data.get(0).getTimestamp() + "</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>To:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>" + data.get(data.size() - 1).getTimestamp() + "</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td>");
        HTMLReport.writeEOL(fw);
        TraceEventStatus status = TraceEventHelper.getStatus(data);
        HTMLReport.writeString(fw, "<td><div style=\"color: " + status.getColor() + ";\">");
        HTMLReport.writeString(fw, status.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Sequence diagram</h2>");
        HTMLReport.writeEOL(fw);
        if (status == TraceEventStatus.GREEN || status == TraceEventStatus.YELLOW) {
            HTMLReport.writeString(fw, "<image src=\"");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".png\" alt=\"SDedit image\"/>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<p/>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "Generate the image by: <i>sdedit -t png -o ");
            HTMLReport.writeString(fw, root);
            HTMLReport.writeString(fw, "/");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".png ");
            HTMLReport.writeString(fw, root);
            HTMLReport.writeString(fw, "/");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".sdx ");
            HTMLReport.writeString(fw, "</i>");
            HTMLReport.writeEOL(fw);
        } else {
            HTMLReport.writeString(fw, "See Description or Data for recorded data");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "<h2>Description</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<thead align=\"left\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<th>Timestamp</th>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<th>Description</th>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</thead>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tbody>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : data) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>");
            if (TraceEventHelper.isRed(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: red;\">");
            } else if (TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: yellow;\">");
            }
            HTMLReport.writeString(fw, Long.toString(te.getTimestamp()));
            if (TraceEventHelper.isRed(te) || TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "</div>");
            }
            HTMLReport.writeString(fw, "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>");
            if (TraceEventHelper.isRed(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: red;\">");
            } else if (TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: yellow;\">");
            }
            HTMLReport.writeString(fw, TraceEvent.asText((TraceEvent)te));
            if (TraceEventHelper.isRed(te) || TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "</div>");
            }
            HTMLReport.writeString(fw, "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</tbody>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Data</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<pre>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : data) {
            HTMLReport.writeString(fw, te.toString());
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</pre>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Usage: HTMLReport <file> [<output>]");
            return;
        }
        File logFile = new File(args[0]);
        FileReader logReader = null;
        String rootDirectory = "report";
        if (args.length > 1) {
            rootDirectory = args[1];
        }
        File root = new File(rootDirectory);
        try {
            logReader = new FileReader(logFile);
            root.mkdirs();
            List<TraceEvent> events = TraceEventHelper.getEvents(logReader);
            Map<String, Map<String, List<TraceEvent>>> filtered = TraceEventHelper.filterEvents(events);
            TreeMap<String, TraceEventStatus> topLevelStatus = new TreeMap<String, TraceEventStatus>();
            for (Map.Entry<String, Map<String, List<TraceEvent>>> entry : filtered.entrySet()) {
                Collection<List<TraceEvent>> values = entry.getValue().values();
                ArrayList<TraceEventStatus> status = new ArrayList<TraceEventStatus>();
                for (List<TraceEvent> l : values) {
                    status.add(TraceEventHelper.getStatus(l));
                }
                topLevelStatus.put(entry.getKey(), TraceEventHelper.mergeStatus(status));
            }
            OutputStreamWriter topLevel = null;
            try {
                topLevel = new FileWriter(root.getAbsolutePath() + "/" + "index.html");
                HTMLReport.generateTopLevelIndexHTML(topLevelStatus, (FileWriter)topLevel);
            }
            finally {
                if (topLevel != null) {
                    try {
                        topLevel.flush();
                        topLevel.close();
                    }
                    catch (Exception e) {}
                }
            }
            for (Map.Entry<String, Map<String, List<TraceEvent>>> entry : filtered.entrySet()) {
                OutputStreamWriter pool = null;
                try {
                    String path = root.getAbsolutePath() + "/" + entry.getKey();
                    File f = new File(path);
                    f.mkdirs();
                    TreeMap<String, TraceEventStatus> status = new TreeMap<String, TraceEventStatus>();
                    for (Map.Entry<String, List<TraceEvent>> dataEntry : entry.getValue().entrySet()) {
                        status.put(dataEntry.getKey(), TraceEventHelper.getStatus(dataEntry.getValue()));
                        String identifier = dataEntry.getKey();
                        OutputStreamWriter cl = null;
                        try {
                            String clPath = path + "/" + identifier;
                            File clF = new File(clPath);
                            clF.mkdirs();
                            cl = new FileWriter(clF.getAbsolutePath() + "/" + "index.html");
                            HTMLReport.generateConnectionListenerIndexHTML(identifier, dataEntry.getValue(), clPath, (FileWriter)cl);
                        }
                        finally {
                            if (cl == null) continue;
                            try {
                                cl.flush();
                                cl.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                    pool = new FileWriter(f.getAbsolutePath() + "/" + "index.html");
                    HTMLReport.generatePoolIndexHTML(entry.getKey(), status, (FileWriter)pool);
                }
                finally {
                    if (pool == null) continue;
                    try {
                        pool.flush();
                        pool.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (logReader != null) {
                try {
                    logReader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

