/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.as.converters.NoTxConnectionFactory;
import org.jboss.jca.as.converters.TxConnectionFactory;

public interface ConnectionFactories {
    public List<TxConnectionFactory> getTxConnectionFactory();

    public List<NoTxConnectionFactory> getNoTxConnectionFactory();

    public static enum Tag {
        UNKNOWN(null),
        TX_CONNECTION_FACTORY("tx-connection-factory"),
        NO_TX_CONNECTION_FACTORY("no-tx-connection-factory");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

