/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jboss.invocation.AbstractInterceptorContext;
import org.jboss.invocation.AsynchronousInterceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InvocationMessages;
import org.wildfly.common.Assert;

public final class AsynchronousInterceptorContext
extends AbstractInterceptorContext
implements Cloneable {
    private static final AsynchronousInterceptor[] EMPTY = new AsynchronousInterceptor[0];
    private AsynchronousInterceptor[] interceptors = EMPTY;
    private int interceptorPosition = 0;
    private AsynchronousInterceptor.ResultSupplier resultSupplier;

    @Override
    public Object getTarget() {
        return super.getTarget();
    }

    @Override
    public void setTarget(Object target) {
        super.setTarget(target);
    }

    @Override
    public Method getMethod() {
        return super.getMethod();
    }

    @Override
    public void setMethod(Method method) {
        super.setMethod(method);
    }

    @Override
    public Constructor<?> getConstructor() {
        return super.getConstructor();
    }

    @Override
    public void setConstructor(Constructor<?> constructor) {
        super.setConstructor(constructor);
    }

    @Override
    public Object[] getParameters() {
        return super.getParameters();
    }

    @Override
    public void setParameters(Object[] parameters) {
        super.setParameters(parameters);
    }

    @Override
    public Map<String, Object> getContextData() throws IllegalStateException {
        return super.getContextData();
    }

    @Override
    public void setContextData(Map<String, Object> contextData) {
        super.setContextData(contextData);
    }

    @Override
    public Object getTimer() {
        return super.getTimer();
    }

    @Override
    public void setTimer(Object timer) {
        super.setTimer(timer);
    }

    @Override
    public <T> T getPrivateData(Class<T> type) {
        return super.getPrivateData(type);
    }

    @Override
    public Object getPrivateData(Object key) {
        return super.getPrivateData(key);
    }

    @Override
    public <T> T putPrivateData(Class<T> type, T value) {
        return super.putPrivateData(type, value);
    }

    @Override
    public Object putPrivateData(Object key, Object value) {
        return super.putPrivateData(key, value);
    }

    public AsynchronousInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public int getNextInterceptorIndex() {
        return this.interceptorPosition;
    }

    public void setInterceptors(AsynchronousInterceptor[] interceptors) {
        this.setInterceptors(interceptors, 0);
    }

    public void setInterceptors(List<AsynchronousInterceptor> interceptorList) {
        this.setInterceptors(interceptorList.toArray(new AsynchronousInterceptor[interceptorList.size()]), 0);
    }

    public void setInterceptors(AsynchronousInterceptor[] interceptors, int nextIndex) {
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors is null");
        }
        this.interceptors = interceptors;
        this.interceptorPosition = nextIndex;
    }

    public void setInterceptors(List<AsynchronousInterceptor> interceptorList, int nextIndex) {
        this.setInterceptors(interceptorList.toArray(new AsynchronousInterceptor[interceptorList.size()]), nextIndex);
    }

    @Override
    public boolean isBlockingCaller() {
        return super.isBlockingCaller();
    }

    @Override
    public void setBlockingCaller(boolean blockingCaller) {
        super.setBlockingCaller(blockingCaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchronousInterceptor.CancellationHandle proceed(AsynchronousInterceptor.ResultHandler resultHandler) {
        Assert.checkNotNullParam((String)"resultHandler", (Object)resultHandler);
        AsynchronousInterceptor[] interceptors = this.interceptors;
        int interceptorPosition = this.interceptorPosition;
        if (interceptorPosition < interceptors.length) {
            this.interceptorPosition = interceptorPosition + 1;
            try {
                AsynchronousInterceptor.CancellationHandle cancellationHandle = interceptors[interceptorPosition].processInvocation(this, resultHandler);
                return cancellationHandle;
            }
            finally {
                this.interceptorPosition = interceptorPosition;
            }
        }
        throw InvocationMessages.msg.cannotProceed();
    }

    InterceptorContext toSynchronous() {
        return new InterceptorContext(this);
    }
}

