/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.invocation.AsynchronousInterceptorContext;
import org.jboss.invocation.InvocationMessages;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;

public interface AsynchronousInterceptor {
    public CancellationHandle processInvocation(AsynchronousInterceptorContext var1, ResultHandler var2);

    public static interface CancellationHandle {
        public static final CancellationHandle NULL = aggressiveCancelRequested -> {};

        public void cancel(boolean var1);
    }

    public static interface ResultSupplier
    extends ExceptionSupplier<Object, Exception> {
        public static final ResultSupplier CANCELLED = () -> {
            throw InvocationMessages.msg.invocationCancelled();
        };

        public Object get() throws Exception;

        default public void discard() {
        }

        public static ResultSupplier failed(Exception cause) {
            return () -> {
                throw cause;
            };
        }

        public static ResultSupplier succeeded(Object result) {
            return () -> result;
        }
    }

    public static interface ResultHandler {
        public void setResult(ResultSupplier var1);

        public void setCancelled();

        public void setException(Exception var1);

        default public <T, U> ResultHandler withAction(final T arg1, final U arg2, final BiConsumer<T, U> action) {
            Assert.checkNotNullParam((String)"action", action);
            final ResultHandler outer = this;
            return new ResultHandler(){

                @Override
                public void setResult(ResultSupplier resultSupplier) {
                    try {
                        action.accept(arg1, arg2);
                    }
                    finally {
                        outer.setResult(resultSupplier);
                    }
                }

                @Override
                public void setCancelled() {
                    try {
                        action.accept(arg1, arg2);
                    }
                    finally {
                        outer.setCancelled();
                    }
                }

                @Override
                public void setException(Exception exception) {
                    try {
                        action.accept(arg1, arg2);
                    }
                    finally {
                        outer.setException(exception);
                    }
                }
            };
        }

        default public <T> ResultHandler withAction(T argument, Consumer<T> action) {
            return this.withAction(action, argument, Consumer::accept);
        }

        default public ResultHandler withAction(Runnable action) {
            return this.withAction(action, Runnable::run);
        }
    }
}

