/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public final class PrivilegedInterceptor
implements Interceptor {
    private static final PrivilegedInterceptor INSTANCE = new PrivilegedInterceptor();
    private static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory(INSTANCE);

    public static PrivilegedInterceptor getInstance() {
        return INSTANCE;
    }

    public static InterceptorFactory getFactory() {
        return FACTORY;
    }

    private PrivilegedInterceptor() {
    }

    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        try {
            return AccessController.doPrivileged(context, context.getPrivateData(AccessControlContext.class));
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

