/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.invocation.proxy.AbstractClassFactory;
import org.jboss.invocation.proxy.ConstructorBodyCreator;
import org.jboss.invocation.proxy.DefaultConstructorBodyCreator;
import org.jboss.invocation.proxy.DefaultMethodBodyCreator;
import org.jboss.invocation.proxy.MethodBodyCreator;
import org.jboss.invocation.proxy.MethodIdentifier;

public abstract class AbstractSubclassFactory<T>
extends AbstractClassFactory<T> {
    private final Set<MethodIdentifier> overriddenMethods = new HashSet<MethodIdentifier>();
    private static final Set<MethodIdentifier> SKIP_BY_DEFAULT;

    protected AbstractSubclassFactory(String className, Class<T> superClass, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        super(className, superClass, classLoader, protectionDomain);
    }

    protected AbstractSubclassFactory(String className, Class<T> superClass, ClassLoader classLoader) {
        super(className, superClass, classLoader);
    }

    protected AbstractSubclassFactory(String className, Class<T> superClass) {
        super(className, superClass);
    }

    protected boolean overrideMethod(Method method, MethodIdentifier identifier, MethodBodyCreator creator) {
        if (!this.overriddenMethods.contains(identifier)) {
            this.overriddenMethods.add(identifier);
            creator.overrideMethod(this.classFile.addMethod(method), method);
            return true;
        }
        return false;
    }

    protected boolean overrideMethod(ClassMethod method, MethodIdentifier identifier, MethodBodyCreator creator) {
        if (!this.overriddenMethods.contains(identifier)) {
            this.overriddenMethods.add(identifier);
            creator.overrideMethod(method, null);
            return true;
        }
        return false;
    }

    protected void overridePublicMethods() {
        this.overridePublicMethods(this.getDefaultMethodOverride());
    }

    @Override
    protected void cleanup() {
        this.overriddenMethods.clear();
    }

    protected void overridePublicMethods(MethodBodyCreator override) {
        for (Method method : this.getSuperClass().getMethods()) {
            MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod(method);
            if (Modifier.isFinal(method.getModifiers()) || SKIP_BY_DEFAULT.contains(identifier)) continue;
            this.overrideMethod(method, identifier, override);
        }
    }

    protected void overrideAllMethods() {
        this.overrideAllMethods(this.getDefaultMethodOverride());
    }

    protected void overrideAllMethods(MethodBodyCreator override) {
        for (Class currentClass = this.getSuperClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Method method : this.getSuperClass().getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers())) continue;
                MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod(method);
                if (Modifier.isFinal(method.getModifiers()) || SKIP_BY_DEFAULT.contains(identifier)) continue;
                this.overrideMethod(method, identifier, override);
            }
        }
    }

    protected void overrideEquals() {
        this.overrideEquals(this.getDefaultMethodOverride());
    }

    protected void overrideEquals(MethodBodyCreator creator) {
        Method equals = null;
        try {
            equals = this.getSuperClass().getMethod("equals", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        creator.overrideMethod(this.classFile.addMethod(equals), equals);
    }

    protected void overrideHashcode() {
        this.overrideHashcode(this.getDefaultMethodOverride());
    }

    protected void overrideHashcode(MethodBodyCreator creator) {
        Method hashCode = null;
        try {
            hashCode = this.getSuperClass().getMethod("hashCode", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        creator.overrideMethod(this.classFile.addMethod(hashCode), hashCode);
    }

    protected void overrideToString() {
        this.overrideToString(this.getDefaultMethodOverride());
    }

    protected void overrideToString(MethodBodyCreator creator) {
        Method toString = null;
        try {
            toString = this.getSuperClass().getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        creator.overrideMethod(this.classFile.addMethod(toString), toString);
    }

    protected void overrideFinalize() {
        this.overrideFinalize(this.getDefaultMethodOverride());
    }

    protected void overrideFinalize(MethodBodyCreator creator) {
        Method finalize = null;
        try {
            finalize = Object.class.getDeclaredMethod("finalize", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        creator.overrideMethod(this.classFile.addMethod(finalize), finalize);
    }

    protected void addInterface(Class<?> interfaceClass) {
        this.addInterface(this.getDefaultMethodOverride(), interfaceClass);
    }

    protected void addInterface(MethodBodyCreator override, Class<?> interfaceClass) {
        this.classFile.addInterface(interfaceClass.getName());
        for (Method method : interfaceClass.getMethods()) {
            override.overrideMethod(this.classFile.addMethod(method), method);
        }
    }

    protected void createConstructorDelegates() {
        this.createConstructorDelegates(this.getDefaultConstructorOverride());
    }

    protected void createConstructorDelegates(ConstructorBodyCreator creator) {
        for (Constructor<?> constructor : this.getSuperClass().getDeclaredConstructors()) {
            if (Modifier.isPrivate(constructor.getModifiers())) continue;
            creator.overrideConstructor(this.classFile.addConstructor(constructor), constructor);
        }
    }

    public MethodBodyCreator getDefaultMethodOverride() {
        return DefaultMethodBodyCreator.INSTANCE;
    }

    public ConstructorBodyCreator getDefaultConstructorOverride() {
        return DefaultConstructorBodyCreator.INSTANCE;
    }

    static {
        HashSet<MethodIdentifier> skip = new HashSet<MethodIdentifier>();
        skip.add(MethodIdentifier.EQUALS);
        skip.add(MethodIdentifier.FINALIZE);
        skip.add(MethodIdentifier.HASH_CODE);
        skip.add(MethodIdentifier.TO_STRING);
        SKIP_BY_DEFAULT = Collections.unmodifiableSet(skip);
    }
}

