/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.SimpleInvocationContext;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClassLoaderClassCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;

public final class InVMRemoteInterceptor
implements Interceptor {
    private static final PrivilegedAction<ClassLoader> GET_CLASS_LOADER_ACTION = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private final Interceptor targetInterceptor;
    private final Method targetMethod;
    private final ClassLoaderClassCloner classCloner;
    private final PassMode passMode;
    private final Object targetInstance;
    private final ClonerConfiguration configuration;

    public InVMRemoteInterceptor(Interceptor targetInterceptor, Method targetMethod, ClassLoader targetClassLoader, PassMode passMode, Object targetInstance) {
        this.targetInterceptor = targetInterceptor;
        this.targetMethod = targetMethod;
        this.passMode = passMode;
        this.targetInstance = targetInstance;
        this.configuration = new ClonerConfiguration();
        this.classCloner = new ClassLoaderClassCloner(targetClassLoader);
        this.configuration.setClassCloner((ClassCloner)this.classCloner);
    }

    @Override
    public Object processInvocation(InvocationContext context) throws Exception {
        Object[] newParameters;
        Object[] parameters = context.getParameters();
        ObjectClonerFactory clonerFactory = ObjectCloners.getSerializingObjectClonerFactory();
        ObjectCloner cloner = clonerFactory.createCloner(this.configuration);
        switch (this.passMode) {
            case REFERENCE_ONLY: {
                newParameters = parameters;
                break;
            }
            case SAME_CLASS_LOADER: {
                int i;
                newParameters = (Object[])parameters.clone();
                int len = newParameters.length;
                for (i = 0; i < len; ++i) {
                    Class<?> origClass;
                    Class newClass;
                    Object param = parameters[i];
                    if (param == null || (newClass = this.classCloner.clone(origClass = param.getClass())) == origClass) continue;
                    newParameters[i] = cloner.clone(param);
                }
                break;
            }
            case VALUE_ONLY: {
                int i;
                int len = parameters.length;
                newParameters = new Object[len];
                for (i = 0; i < len; ++i) {
                    newParameters[i] = cloner.clone(parameters[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        SimpleInvocationContext newContext = new SimpleInvocationContext(this.targetInstance, this.targetMethod, newParameters, context.getContextData(), null);
        Object result = this.targetInterceptor.processInvocation(newContext);
        switch (this.passMode) {
            case REFERENCE_ONLY: {
                return result;
            }
            case SAME_CLASS_LOADER: {
                if (result == null) {
                    return null;
                }
                ClassLoaderClassCloner classCloner = new ClassLoaderClassCloner(this.getContextClassLoader());
                Class classClone = classCloner.clone(result.getClass());
                if (classClone == result.getClass()) {
                    return result;
                }
            }
            case VALUE_ONLY: {
                if (result == null) {
                    return null;
                }
                ClonerConfiguration copyBackConfiguration = new ClonerConfiguration();
                copyBackConfiguration.setClassCloner((ClassCloner)new ClassLoaderClassCloner(this.getContextClassLoader()));
                return clonerFactory.createCloner(copyBackConfiguration).clone(result);
            }
        }
        throw new IllegalStateException();
    }

    private ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(GET_CLASS_LOADER_ACTION);
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static enum PassMode {
        REFERENCE_ONLY,
        SAME_CLASS_LOADER,
        VALUE_ONLY;

    }
}

