/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Serializable;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.DelegatingInvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InvocationMessages;

class ChainedInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 7951017996430287249L;
    private final Interceptor[] interceptors;

    ChainedInterceptor(Interceptor ... interceptors) {
        if (interceptors == null) {
            throw InvocationMessages.msg.nullParameter("interceptors");
        }
        this.interceptors = interceptors;
    }

    @Override
    public Object processInvocation(InvocationContext context) throws Exception {
        DelegatingInvocationContext childContext = new DelegatingInvocationContext(context){
            private int index;
            {
                this.index = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object proceed() throws Exception {
                if (this.index < ChainedInterceptor.this.interceptors.length) {
                    try {
                        Object object = ChainedInterceptor.this.interceptors[this.index++].processInvocation(this);
                        return object;
                    }
                    finally {
                        --this.index;
                    }
                }
                return super.proceed();
            }
        };
        return childContext.proceed();
    }
}

