/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import org.jboss.gravia.resource.Version;

public final class ResourceIdentity {
    private final String symbolicName;
    private final Version version;

    public static ResourceIdentity create(String symbolicName, Version version) {
        return new ResourceIdentity(symbolicName, version);
    }

    public static ResourceIdentity fromString(String identity) {
        int index = identity.indexOf(58);
        String namePart = index > 0 ? identity.substring(0, index) : identity;
        String versionPart = index > 0 ? identity.substring(index + 1) : "0.0.0";
        return new ResourceIdentity(namePart, Version.parseVersion(versionPart));
    }

    private ResourceIdentity(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolicName");
        }
        this.symbolicName = symbolicName;
        this.version = version != null ? version : Version.emptyVersion;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ResourceIdentity)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.symbolicName + ":" + this.version;
    }
}

