/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resolver.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.resolver.PreferencePolicy;
import org.jboss.gravia.resolver.ResolveContext;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceStore;
import org.jboss.gravia.resource.Wiring;

public abstract class AbstractResolveContext
implements ResolveContext {
    private final ResourceStore resourceStore;
    private final List<Resource> mandatory;
    private final List<Resource> optional;
    private PreferencePolicy preferencePolicy;

    public AbstractResolveContext(ResourceStore resourceStore, Set<Resource> manres, Set<Resource> optres) {
        Resource res;
        if (resourceStore == null) {
            throw new IllegalArgumentException("Null resourceStore");
        }
        this.resourceStore = resourceStore;
        this.mandatory = new ArrayList<Resource>(manres != null ? manres : Collections.emptyList());
        this.optional = new ArrayList<Resource>(optres != null ? optres : Collections.emptyList());
        for (Resource res2 : this.mandatory) {
            if (resourceStore.getResource(res2.getIdentity()) != null) continue;
            throw new IllegalArgumentException("Resource not in provided store: " + res2);
        }
        for (Resource res2 : this.optional) {
            if (resourceStore.getResource(res2.getIdentity()) != null) continue;
            throw new IllegalArgumentException("Resource not in provided store: " + res2);
        }
        Map<Resource, Wiring> wirings = this.getWirings();
        Iterator<Resource> itres = this.mandatory.iterator();
        while (itres.hasNext()) {
            res = itres.next();
            if (wirings.get(res) == null) continue;
            itres.remove();
        }
        itres = this.optional.iterator();
        while (itres.hasNext()) {
            res = itres.next();
            if (wirings.get(res) == null) continue;
            itres.remove();
        }
    }

    protected abstract PreferencePolicy createPreferencePolicy();

    private PreferencePolicy getPreferencePolicyInternal() {
        if (this.preferencePolicy == null) {
            this.preferencePolicy = this.createPreferencePolicy();
        }
        return this.preferencePolicy;
    }

    @Override
    public Collection<Resource> getMandatoryResources() {
        return Collections.unmodifiableList(this.mandatory);
    }

    @Override
    public Collection<Resource> getOptionalResources() {
        return Collections.unmodifiableList(this.optional);
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        HashMap<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
        Iterator itres = this.resourceStore.getResources();
        while (itres.hasNext()) {
            Resource res = (Resource)itres.next();
            Wiring wiring = res.getWiring();
            if (wiring == null) continue;
            wirings.put(res, wiring);
        }
        return Collections.unmodifiableMap(wirings);
    }

    @Override
    public List<Capability> findProviders(Requirement req) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        result.addAll(this.resourceStore.findProviders(req));
        this.getPreferencePolicyInternal().sort(result);
        return result;
    }
}

