/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.util.HashSet;
import java.util.Iterator;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionManager;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsManagedConnectionFactory;
import org.jboss.resource.adapter.jms.JmsSession;
import org.jboss.resource.adapter.jms.JmsSessionFactory;

public class JmsSessionFactoryImpl
implements JmsSessionFactory,
Referenceable {
    private static final Logger log = Logger.getLogger(JmsSessionFactoryImpl.class);
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = "java:comp/TransactionSynchronizationRegistry";
    private boolean closed = false;
    private boolean trace = log.isTraceEnabled();
    private Reference reference;
    private String userName;
    private String password;
    private String clientID;
    private int type;
    private boolean started = false;
    private JmsManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private HashSet sessions = new HashSet();
    private HashSet tempQueues = new HashSet();
    private HashSet tempTopics = new HashSet();
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public JmsSessionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm, int type) {
        this.mcf = (JmsManagedConnectionFactory)mcf;
        this.cm = cm;
        this.cm = cm == null ? new JmsConnectionManager() : cm;
        this.type = type;
        if (this.trace) {
            log.trace((Object)("mcf=" + mcf + ", cm=" + cm + ", type=" + type));
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException("Can not get a queue session from a topic connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        if (this.clientID == null) {
            return this.mcf.getClientID();
        }
        return this.clientID;
    }

    public void setClientID(String cID) throws JMSException {
        if (this.mcf.isStrict().booleanValue()) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
        this.checkClosed();
        if (this.clientID != null) {
            throw new IllegalStateException("Cannot change client id");
        }
        this.clientID = cID;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this.mcf.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkClosed();
        if (this.trace) {
            log.trace((Object)("start() " + this));
        }
        HashSet hashSet = this.sessions;
        synchronized (hashSet) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (JmsSession session : this.sessions) {
                session.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (this.mcf.isStrict().booleanValue()) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
        this.checkClosed();
        if (this.trace) {
            log.trace((Object)("stop() " + this));
        }
        HashSet hashSet = this.sessions;
        synchronized (hashSet) {
            if (!this.started) {
                return;
            }
            this.started = true;
            for (JmsSession session : this.sessions) {
                session.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Iterator i;
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.trace) {
            log.trace((Object)("close() " + this));
        }
        HashSet hashSet = this.sessions;
        synchronized (hashSet) {
            i = this.sessions.iterator();
            while (i.hasNext()) {
                JmsSession session = (JmsSession)i.next();
                try {
                    session.closeSession();
                }
                catch (Throwable t) {
                    log.trace((Object)"Error closing session", t);
                }
                i.remove();
            }
        }
        if (this.mcf.isDeleteTemporaryDestinations().booleanValue()) {
            TemporaryQueue temp;
            hashSet = this.tempQueues;
            synchronized (hashSet) {
                i = this.tempQueues.iterator();
                while (i.hasNext()) {
                    temp = (TemporaryQueue)i.next();
                    try {
                        if (this.trace) {
                            log.trace((Object)("Closing temporary queue " + temp + " for " + this));
                        }
                        temp.delete();
                    }
                    catch (Throwable t) {
                        log.trace((Object)"Error deleting temporary queue", t);
                    }
                    i.remove();
                }
            }
            hashSet = this.tempTopics;
            synchronized (hashSet) {
                i = this.tempTopics.iterator();
                while (i.hasNext()) {
                    temp = (TemporaryTopic)i.next();
                    try {
                        if (this.trace) {
                            log.trace((Object)("Closing temporary topic " + temp + " for " + this));
                        }
                        temp.delete();
                    }
                    catch (Throwable t) {
                        log.trace((Object)"Error deleting temporary topic", t);
                    }
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(JmsSession session) throws JMSException {
        HashSet hashSet = this.sessions;
        synchronized (hashSet) {
            this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTemporaryQueue(TemporaryQueue temp) {
        HashSet hashSet = this.tempQueues;
        synchronized (hashSet) {
            this.tempQueues.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTemporaryTopic(TemporaryTopic temp) {
        HashSet hashSet = this.tempTopics;
        synchronized (hashSet) {
            this.tempTopics.add(temp);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool pool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String name, ServerSessionPool pool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        if (this.isInTransaction()) {
            transacted = true;
            acknowledgeMode = 0;
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public Session createSession(int sessionMode) throws JMSException {
        boolean transacted;
        this.checkClosed();
        boolean bl = transacted = sessionMode == 0;
        if (this.isInTransaction()) {
            transacted = true;
            sessionMode = 0;
        }
        return this.allocateConnection(transacted, sessionMode, this.type);
    }

    public Session createSession() throws JMSException {
        boolean transacted = false;
        int sessionMode = 1;
        if (this.isInTransaction()) {
            transacted = true;
            sessionMode = 0;
        }
        return this.allocateConnection(transacted, sessionMode, this.type);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    protected JmsSession allocateConnection(boolean transacted, int acknowledgeMode, int sessionType) throws JMSException {
        try {
            HashSet hashSet = this.sessions;
            synchronized (hashSet) {
                if (this.mcf.isStrict().booleanValue() && !this.sessions.isEmpty()) {
                    throw new IllegalStateException("Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
                }
                if (transacted) {
                    acknowledgeMode = 0;
                }
                JmsConnectionRequestInfo info = new JmsConnectionRequestInfo(transacted, acknowledgeMode, sessionType);
                info.setUserName(this.userName);
                info.setPassword(this.password);
                info.setClientID(this.clientID);
                info.setDefaults(this.mcf.getProperties());
                if (this.trace) {
                    log.trace((Object)("Allocating session for " + this + " with request info=" + info));
                }
                JmsSession session = (JmsSession)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)info);
                try {
                    if (this.trace) {
                        log.trace((Object)("Allocated  " + this + " session=" + session));
                    }
                    session.setJmsSessionFactory(this);
                    if (this.started) {
                        session.start();
                    }
                    this.sessions.add(session);
                    return session;
                }
                catch (Throwable t) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new RuntimeException("Unexpected error: ", t);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"could not create session", (Throwable)e);
            JMSException je = new JMSException("Could not create a session: " + e);
            je.setLinkedException(e);
            throw je;
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
    }

    private boolean isInTransaction() {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        boolean inTx = tsr.getTransactionStatus() == 0;
        return inTx;
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry cachedTSR = this.transactionSynchronizationRegistry;
        if (cachedTSR == null) {
            this.transactionSynchronizationRegistry = cachedTSR = (TransactionSynchronizationRegistry)this.lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
        }
        return cachedTSR;
    }

    private Object lookup(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }
}

