/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.IncompleteDeployments;
import org.jboss.deployers.spi.MissingDependency;

public class IncompleteDeploymentException
extends DeploymentException {
    private static final long serialVersionUID = 1433292979582684692L;
    private IncompleteDeployments incompleteDeployments;

    public IncompleteDeploymentException() {
    }

    public IncompleteDeploymentException(IncompleteDeployments incompleteDeployments) {
        if (incompleteDeployments == null) {
            throw new IllegalArgumentException("Null incompleteDeployments");
        }
        this.incompleteDeployments = incompleteDeployments;
    }

    public IncompleteDeployments getIncompleteDeployments() {
        return this.incompleteDeployments;
    }

    public String getMessage() {
        Map<String, Throwable> contextsInError;
        Map<String, Throwable> deploymentsInError;
        StringBuilder buffer = new StringBuilder();
        buffer.append("Summary of incomplete deployments (SEE PREVIOUS ERRORS FOR DETAILS):\n");
        Collection<String> deploymentsMissingDeployers = this.incompleteDeployments.getDeploymentsMissingDeployer();
        if (!deploymentsMissingDeployers.isEmpty()) {
            buffer.append("\n*** DEPLOYMENTS MISSING DEPLOYERS: Name\n\n");
            for (String name : deploymentsMissingDeployers) {
                buffer.append(name).append('\n');
            }
        }
        if (!(deploymentsInError = this.incompleteDeployments.getDeploymentsInError()).isEmpty()) {
            buffer.append("\n*** DEPLOYMENTS IN ERROR: Name -> Error\n\n");
            for (Map.Entry<String, Throwable> entry : deploymentsInError.entrySet()) {
                buffer.append(entry.getKey()).append(" -> ").append(entry.getValue().toString()).append("\n\n");
            }
        }
        HashMap<String, String> rootCauses = new HashMap<String, String>();
        Map<String, Set<MissingDependency>> contextsMissingDependencies = this.incompleteDeployments.getContextsMissingDependencies();
        if (!contextsMissingDependencies.isEmpty()) {
            for (Map.Entry<String, Set<MissingDependency>> entry : contextsMissingDependencies.entrySet()) {
                for (MissingDependency dependency : entry.getValue()) {
                    rootCauses.put(dependency.getDependency(), dependency.getActualState());
                }
            }
        }
        if (!(contextsInError = this.incompleteDeployments.getContextsInError()).isEmpty()) {
            for (Map.Entry<String, Throwable> entry : contextsInError.entrySet()) {
                Throwable t = entry.getValue();
                if (t == null) {
                    rootCauses.put(entry.getKey(), "** UNKNOWN ERROR **");
                    continue;
                }
                rootCauses.put(entry.getKey(), t.toString());
            }
        }
        if (!contextsMissingDependencies.isEmpty()) {
            buffer.append("\n*** CONTEXTS MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n\n");
            for (Map.Entry<String, Object> entry : contextsMissingDependencies.entrySet()) {
                String name = entry.getKey();
                buffer.append(name).append("\n");
                for (MissingDependency dependency : (Set)entry.getValue()) {
                    buffer.append(" -> ").append(dependency.getDependency());
                    buffer.append('{').append(dependency.getRequiredState());
                    buffer.append(':').append(dependency.getActualState()).append("}");
                    buffer.append("\n");
                }
                buffer.append('\n');
                rootCauses.remove(name);
            }
        }
        if (!rootCauses.isEmpty()) {
            buffer.append("\n*** CONTEXTS IN ERROR: Name -> Error\n\n");
            for (Map.Entry<String, Object> entry : rootCauses.entrySet()) {
                buffer.append(entry.getKey()).append(" -> ").append((String)entry.getValue()).append("\n\n");
            }
        }
        return buffer.toString();
    }
}

