/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs.file;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.deployers.plugins.structure.ContextInfoImpl;
import org.jboss.deployers.plugins.structure.vfs.AbstractStructureDeployer;
import org.jboss.deployers.plugins.structure.vfs.file.SecurityActions;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStructure
extends AbstractStructureDeployer {
    private static Set<String> fileSuffixes = new CopyOnWriteArraySet<String>();

    public FileStructure() {
    }

    public FileStructure(Set<String> suffixes) {
        fileSuffixes.clear();
        fileSuffixes.addAll(suffixes);
    }

    public Set<String> getSuffixes() {
        return fileSuffixes;
    }

    public static boolean addFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.add(suffix);
    }

    public static boolean removeFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.remove(suffix);
    }

    public static boolean isKnownFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        int index = name.lastIndexOf(45);
        if (index == -1) {
            return false;
        }
        String suffix = name.substring(index);
        return fileSuffixes.contains(suffix);
    }

    @Override
    public boolean determineStructure(VirtualFile root, StructureMetaData metaData, StructuredDeployers deployers) {
        try {
            boolean trace = this.log.isTraceEnabled();
            if (SecurityActions.isLeaf(root)) {
                boolean isFile = false;
                if (trace) {
                    this.log.trace((Object)(root + " is not a leaf"));
                }
                if (!this.isTopLevel(root, metaData)) {
                    if (!FileStructure.isKnownFile(root.getName())) {
                        if (trace) {
                            this.log.trace((Object)"... no - it is not a top level file and not a known name");
                        }
                    } else {
                        if (trace) {
                            this.log.trace((Object)"... ok - not a top level file but it is a known name");
                        }
                        isFile = true;
                    }
                } else {
                    if (trace) {
                        this.log.trace((Object)"... ok - it is a top level file");
                    }
                    isFile = true;
                }
                ContextInfoImpl context = new ContextInfoImpl(root.getPathName());
                metaData.addContext(context);
                if (trace) {
                    this.log.trace((Object)(root + " isFile: " + isFile));
                }
                return isFile;
            }
            if (trace) {
                this.log.trace((Object)"... no - not a file.");
            }
            return false;
        }
        catch (Exception e) {
            this.log.warn((Object)("Error determining structure: " + root.getName()), (Throwable)e);
            return false;
        }
    }

    static {
        fileSuffixes.add("-service.xml");
        fileSuffixes.add("-beans.xml");
        fileSuffixes.add("-ds.xml");
        fileSuffixes.add("-aop.xml");
    }
}

