/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs;

import java.io.IOException;
import java.util.ArrayList;
import org.jboss.deployers.plugins.structure.ClassPathInfoImpl;
import org.jboss.deployers.plugins.structure.vfs.CandidateStructureVisitorFactory;
import org.jboss.deployers.plugins.structure.vfs.SecurityActions;
import org.jboss.deployers.plugins.structure.vfs.jar.JARCandidateStructureVisitorFactory;
import org.jboss.deployers.spi.structure.vfs.ClassPathInfo;
import org.jboss.deployers.spi.structure.vfs.ContextInfo;
import org.jboss.deployers.spi.structure.vfs.StructureDeployer;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

public abstract class AbstractStructureDeployer
implements StructureDeployer {
    protected Logger log = Logger.getLogger(this.getClass());
    private int relativeOrder = Integer.MAX_VALUE;
    private CandidateStructureVisitorFactory candidateStructureVisitorFactory = JARCandidateStructureVisitorFactory.INSTANCE;

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int order) {
        this.relativeOrder = order;
    }

    public CandidateStructureVisitorFactory getCandidateStructureVisitorFactory() {
        return this.candidateStructureVisitorFactory;
    }

    public void setCandidateStructureVisitorFactory(CandidateStructureVisitorFactory candidateStructureVisitorFactory) {
        if (candidateStructureVisitorFactory == null) {
            throw new IllegalArgumentException("Null candidateStructureVisitorFactory");
        }
        this.candidateStructureVisitorFactory = candidateStructureVisitorFactory;
    }

    public abstract boolean determineStructure(VirtualFile var1, StructureMetaData var2, StructuredDeployers var3);

    public boolean isTopLevel(VirtualFile file, StructureMetaData metaData) throws IOException {
        VirtualFile parent = file.getParent();
        String parentPath = parent != null ? parent.getPathName() : null;
        boolean isTopLevel = parentPath == null || metaData.getContext(parentPath) == null;
        return isTopLevel;
    }

    protected void addClassPath(VirtualFile root, VirtualFile entry, boolean includeEntry, boolean includeRootManifestCP, ContextInfo context) throws IOException {
        String rootPath;
        ArrayList<VirtualFile> paths;
        block7: {
            paths = new ArrayList<VirtualFile>();
            if (includeEntry) {
                paths.add(entry);
            }
            rootPath = root.getPathName();
            if (includeRootManifestCP && !SecurityActions.isLeaf(entry)) {
                try {
                    VFSUtils.addManifestLocations((VirtualFile)entry, paths);
                }
                catch (Exception e) {
                    if (!this.log.isTraceEnabled()) break block7;
                    this.log.trace((Object)"Failed to add manifest locations", (Throwable)e);
                }
            }
        }
        ArrayList<ClassPathInfo> pathInfo = new ArrayList<ClassPathInfo>();
        if (context.getClassPath() != null) {
            pathInfo.addAll(context.getClassPath());
        }
        for (VirtualFile vf : paths) {
            String cp = vf.getPathName();
            if (!"".equals(rootPath) && cp.startsWith(rootPath)) {
                cp = cp.length() == rootPath.length() ? "" : cp.substring(rootPath.length() + 1);
            }
            ClassPathInfoImpl cpi = new ClassPathInfoImpl(cp);
            pathInfo.add(cpi);
        }
        context.setClassPath(pathInfo);
    }

    protected void addAllChildren(VirtualFile parent, StructureMetaData metaData, StructuredDeployers deployers) throws Exception {
        this.addChildren(parent, metaData, deployers, null);
    }

    protected void addChildren(VirtualFile parent, StructureMetaData metaData, StructuredDeployers deployers, VisitorAttributes attributes) throws Exception {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        VirtualFileVisitor visitor = this.candidateStructureVisitorFactory.createVisitor(parent, metaData, deployers, attributes);
        parent.visit(visitor);
    }
}

