/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.attachments;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.deployers.plugins.attachments.AbstractAttachments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsImpl
extends AbstractAttachments {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private AtomicInteger changeCount = new AtomicInteger();

    @Override
    public Map<String, Object> getAttachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public void setAttachments(Map<String, Object> map) {
        this.attachments.clear();
        this.attachments.putAll(map);
        this.changeCount.addAndGet(map.size());
    }

    @Override
    public Object addAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment");
        }
        Object value = this.attachments.put(name, attachment);
        this.changeCount.incrementAndGet();
        return value;
    }

    @Override
    public Object getAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.attachments.get(name);
    }

    @Override
    public boolean isAttachmentPresent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.attachments.containsKey(name);
    }

    @Override
    public Object removeAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        Object value = this.attachments.remove(name);
        this.changeCount.incrementAndGet();
        return value;
    }

    @Override
    public void clear() {
        this.attachments.clear();
        this.changeCount.incrementAndGet();
    }

    @Override
    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    @Override
    public int getChangeCount() {
        return this.changeCount.intValue();
    }

    @Override
    public void clearChangeCount() {
        this.changeCount.set(0);
    }
}

