/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.impl.container;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.container.spi.BeanContext;
import org.jboss.ejb3.container.spi.ContainerInvocation;
import org.jboss.ejb3.container.spi.EJBContainer;
import org.jboss.ejb3.container.spi.EJBInstanceManager;
import org.jboss.ejb3.container.spi.InterceptorRegistry;
import org.jboss.ejb3.container.spi.lifecycle.EJBLifecycleHandler;
import org.jboss.ejb3.singleton.spi.SingletonEJBInstanceManager;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;

public class SingletonContainer
implements EJBContainer,
EJBLifecycleHandler {
    private static Logger logger = Logger.getLogger(SingletonContainer.class);
    private Class<?> beanClass;
    private JBossSessionBean31MetaData sessionBeanMetaData;
    private SingletonEJBInstanceManager instanceManager;
    private InterceptorRegistry interceptorRegistry;

    public SingletonContainer(Class<?> beanClass, JBossSessionBean31MetaData sessionBeanMetaData, InterceptorRegistry interceptorRegistry) {
        if (beanClass == null || sessionBeanMetaData == null) {
            throw new IllegalArgumentException(SingletonContainer.class.getSimpleName() + " cannot be constructed out of a null bean class or null bean metadata");
        }
        if (!sessionBeanMetaData.isSingleton()) {
            throw new IllegalStateException("Bean named " + sessionBeanMetaData.getEjbName() + " with class " + sessionBeanMetaData.getEjbClass() + " is NOT a singleton bean");
        }
        if (interceptorRegistry == null) {
            throw new IllegalArgumentException(SingletonContainer.class.getSimpleName() + " cannot be constructed out of a null interceptor registry");
        }
        this.beanClass = beanClass;
        this.sessionBeanMetaData = sessionBeanMetaData;
        this.interceptorRegistry = interceptorRegistry;
    }

    public void create() {
    }

    public void start() {
        if (this.sessionBeanMetaData.isInitOnStartup()) {
            this.instanceManager.create();
        }
    }

    public void stop() {
    }

    public void destroy() {
        this.instanceManager.destroy();
    }

    public EJBInstanceManager getBeanInstanceManager() {
        return this.instanceManager;
    }

    public void setBeanInstanceManager(SingletonEJBInstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    public String getEJBClass() {
        return this.beanClass.getName();
    }

    public String getEJBName() {
        return this.sessionBeanMetaData.getEjbName();
    }

    public JBossEnterpriseBeanMetaData getMetaData() {
        return this.sessionBeanMetaData;
    }

    public Object invoke(ContainerInvocation containerInvocation) throws Exception {
        BeanContext beanContext = this.instanceManager.get();
        return this.interceptorRegistry.intercept(containerInvocation, beanContext);
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    public void postConstruct(BeanContext beanContext) throws Exception {
        this.interceptorRegistry.invokePostConstruct(beanContext);
    }

    public void preDestroy(BeanContext beanContext) throws Exception {
        this.interceptorRegistry.invokePreDestroy(beanContext);
    }

    public ClassLoader getClassLoader() {
        return this.beanClass.getClassLoader();
    }

    public Context getENC() {
        try {
            return new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

