/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import java.util.Hashtable;
import java.util.Set;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.DomainDefinition;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.resolvers.MessageDestinationReferenceResolver;
import org.jboss.ejb3.singleton.aop.impl.AOPBasedSingletonContainer;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public class SingletonContainerDeployer
extends AbstractRealDeployerWithInput<JBossEnterpriseBeanMetaData>
implements DeploymentVisitor<JBossEnterpriseBeanMetaData> {
    private static Logger logger = Logger.getLogger(SingletonContainerDeployer.class);
    private MessageDestinationReferenceResolver messageDestinationResolver;
    private EjbReferenceResolver ejbReferenceResolver;
    private PersistenceUnitDependencyResolver puResolver;
    private JavaEEComponentInformer javaeeComponentInformer;

    public SingletonContainerDeployer() {
        this.setDeploymentVisitor(this);
        this.setInput(JBossEnterpriseBeanMetaData.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
        this.addOutput(EJBContainer.class);
        this.addInput(AttachmentNames.PROCESSED_METADATA);
    }

    public void deploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMetaData) throws DeploymentException {
        AOPBasedSingletonContainer singletonContainer;
        if (!beanMetaData.getJBossMetaData().isEJB31()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring non-EJB3.1 bean " + beanMetaData.getName()));
            }
            return;
        }
        if (!beanMetaData.isSession()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring non-session bean " + beanMetaData.getName()));
            }
            return;
        }
        if (!(beanMetaData instanceof JBossSessionBean31MetaData)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring bean " + beanMetaData.getName() + " because its metadata is not of type " + JBossSessionBean31MetaData.class));
            }
            return;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)beanMetaData;
        if (!sessionBean.isSingleton()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring non-singleton bean " + sessionBean.getName()));
            }
            return;
        }
        ClassLoader classLoader = unit.getClassLoader();
        String domainName = AOPBasedSingletonContainer.getAOPDomainName();
        DomainDefinition singletonContainerAOPDomain = AspectManager.instance().getContainer(domainName);
        if (singletonContainerAOPDomain == null) {
            throw new DeploymentException(domainName + " AOP domain not configured - cannot deploy EJB named " + beanMetaData.getEjbName() + " in unit " + unit);
        }
        Hashtable ctxProperties = new Hashtable();
        try {
            singletonContainer = new AOPBasedSingletonContainer(classLoader, sessionBean.getEjbClass(), sessionBean.getEjbName(), (Domain)singletonContainerAOPDomain.getManager(), ctxProperties, sessionBean, unit);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException((Throwable)cnfe);
        }
        singletonContainer.setEjbReferenceResolver(this.ejbReferenceResolver);
        singletonContainer.setMessageDestinationResolver(this.messageDestinationResolver);
        singletonContainer.setPersistenceUnitResolver(this.puResolver);
        singletonContainer.instantiated();
        singletonContainer.processMetadata();
        this.installContainer(unit, singletonContainer.getObjectName().getCanonicalName(), singletonContainer);
    }

    public void undeploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData enterpriseBean) {
    }

    public Class<JBossEnterpriseBeanMetaData> getVisitorType() {
        return JBossEnterpriseBeanMetaData.class;
    }

    private void installContainer(DeploymentUnit unit, String containerMCBeanName, AOPBasedSingletonContainer container) {
        BeanMetaDataBuilder containerBMDBuilder = BeanMetaDataBuilder.createBuilder((String)containerMCBeanName, (String)container.getClass().getName());
        containerBMDBuilder.setConstructorValue((Object)container);
        if (container.getDependencyPolicy() instanceof MCDependencyPolicy) {
            Set supplies;
            Set demands;
            MCDependencyPolicy policy = (MCDependencyPolicy)container.getDependencyPolicy();
            Set dependencies = policy.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                for (DependencyMetaData dependency : dependencies) {
                    containerBMDBuilder.addDependency(dependency.getDependency());
                }
            }
            if ((demands = policy.getDemands()) != null && !demands.isEmpty()) {
                for (DemandMetaData demand : demands) {
                    containerBMDBuilder.addDemand(demand.getDemand());
                }
            }
            if ((supplies = policy.getSupplies()) != null && !supplies.isEmpty()) {
                for (SupplyMetaData supply : supplies) {
                    containerBMDBuilder.addSupply(supply.getSupply());
                }
            }
        }
        String javaCompMCBeanName = this.getJavaEEComponentMCBeanName(unit);
        AbstractInjectionValueMetaData javaCompInjectMetaData = new AbstractInjectionValueMetaData((Object)javaCompMCBeanName);
        containerBMDBuilder.addPropertyMetaData("javaComp", (ValueMetaData)javaCompInjectMetaData);
        DeploymentUnit parentUnit = unit.getParent();
        parentUnit.addAttachment(BeanMetaData.class + ":" + containerMCBeanName, (Object)containerBMDBuilder.getBeanMetaData());
        unit.addAttachment(EJBContainer.class + ":" + containerMCBeanName, (Object)container);
    }

    private String getJavaEEComponentMCBeanName(DeploymentUnit deploymentUnit) {
        String applicationName = this.javaeeComponentInformer.getApplicationName(deploymentUnit);
        String moduleName = this.javaeeComponentInformer.getModulePath(deploymentUnit);
        String componentName = this.javaeeComponentInformer.getComponentName(deploymentUnit);
        StringBuilder builder = new StringBuilder("jboss.naming:");
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        if (componentName != null) {
            builder.append(",component=").append(componentName);
        }
        return builder.toString();
    }

    @Inject
    public void setPersistenceUnitResolver(PersistenceUnitDependencyResolver puResolver) {
        this.puResolver = puResolver;
    }

    @Inject
    public void setMessageDestinationResolver(MessageDestinationReferenceResolver messageDestResolver) {
        this.messageDestinationResolver = messageDestResolver;
    }

    @Inject
    public void setEjbRefResolver(EjbReferenceResolver ejbRefResolver) {
        this.ejbReferenceResolver = ejbRefResolver;
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer componentInformer) {
        this.javaeeComponentInformer = componentInformer;
    }
}

