/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.base;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class SecurityActions
{
   Constructor<?> getConstructor(final Class<?> clazz, final Class<?>...parameterTypes) throws NoSuchMethodException
   {
      if (System.getSecurityManager() == null)
         return clazz.getConstructor(parameterTypes);
      
      try
      {
         return AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>()
         {
   
            public Constructor<?> run() throws Exception
            {
               return clazz.getConstructor(parameterTypes);
            }
         });
      }
      catch(PrivilegedActionException e)
      {
         if (e.getCause() instanceof NoSuchMethodException)
            throw (NoSuchMethodException)e.getCause();
         throw new RuntimeException(e.getCause());
      }
   }
   
   Object newInstance(final Class<?> clazz) throws Exception
   {
      if (System.getSecurityManager() == null)
         return clazz.newInstance();
      
      try
      {
         return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>()
         {
   
            public Object run() throws Exception
            {
               return clazz.newInstance();
            }
         });
      }
      catch(PrivilegedActionException e)
      {
         if (e.getCause() instanceof Exception)
            throw (Exception)e.getCause();
         throw new RuntimeException(e.getCause());
      }
   }
   
}
