/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.metadata.helpers;

import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionTranslator
implements Translator {
    private Object translator;
    private Method method;

    public ReflectionTranslator(Object translator, String methodName) throws Exception {
        if (translator == null) {
            throw new IllegalArgumentException("Null translator");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Null method name");
        }
        this.translator = translator;
        this.method = translator.getClass().getMethod(methodName, ClassLoader.class, String.class, Class.class, ProtectionDomain.class, byte[].class);
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
        return (byte[])this.method.invoke(this.translator, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    public void unregisterClassLoader(ClassLoader loader) {
    }
}

