/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.policy;

import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.dependency.spi.Controller;

public class DynamicClassLoaderPolicyFactory
implements ClassLoaderPolicyFactory {
    private Controller controller;
    private Domain domain;
    private RequirementDependencyItem item;

    public DynamicClassLoaderPolicyFactory(Controller controller, Domain domain, RequirementDependencyItem item) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        if (item == null) {
            throw new IllegalArgumentException("Null item");
        }
        this.controller = controller;
        this.domain = domain;
        this.item = item;
    }

    public ClassLoaderPolicy createClassLoaderPolicy() {
        Module iDependOnModule;
        String name = (String)this.item.getIDependOn();
        if (name == null) {
            this.item.resolve(this.controller);
            name = (String)this.item.getIDependOn();
            if (name == null) {
                return null;
            }
        }
        if ((iDependOnModule = this.domain.getModule(name)) == null) {
            throw new IllegalStateException("Module not found with name: " + name);
        }
        if (!(iDependOnModule instanceof ClassLoaderPolicyModule)) {
            throw new IllegalStateException("Unable to determine ClassLoaderPolicy from module: " + iDependOnModule);
        }
        ClassLoaderPolicyModule classLoaderPolicyModule = (ClassLoaderPolicyModule)iDependOnModule;
        return classLoaderPolicyModule.getPolicy();
    }
}

