/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloading.plugins.metadata.ModuleRequirement;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.ClassLoadingAdmin;
import org.jboss.classloading.spi.dependency.ClassLoadingSpace;
import org.jboss.classloading.spi.dependency.ExportPackage;
import org.jboss.classloading.spi.dependency.ImportModule;
import org.jboss.classloading.spi.dependency.LifeCycle;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.dependency.ResolutionContext;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
implements ClassLoadingAdmin {
    private static final Logger log = Logger.getLogger(Domain.class);
    private String name;
    private ClassLoading classLoading;
    private String parentDomainName;
    private boolean parentFirst;
    private List<Module> modules = new CopyOnWriteArrayList<Module>();
    private Map<String, Module> modulesByName = new ConcurrentHashMap<String, Module>();

    public Domain(ClassLoading classLoading, String name, String parentDomainName, boolean parentFirst) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (classLoading == null) {
            throw new IllegalArgumentException("Null classLoading");
        }
        this.classLoading = classLoading;
        this.name = name;
        this.parentDomainName = parentDomainName;
        this.parentFirst = parentFirst;
    }

    public String getName() {
        return this.name;
    }

    public String getParentDomainName() {
        return this.parentDomainName;
    }

    public Domain getParentDomain() {
        if (this.parentDomainName != null) {
            return this.classLoading.getDomain(this.parentDomainName);
        }
        return null;
    }

    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public synchronized void addModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        Domain domain = module.getDomain();
        if (domain != null) {
            throw new IllegalArgumentException("The module is already registered with the domain " + domain.getName());
        }
        String contextName = module.getContextName();
        if (this.modulesByName.containsKey(contextName)) {
            throw new IllegalArgumentException("The context " + contextName + " is already registered in domain " + this.getName());
        }
        log.debug((Object)(this + " add module " + module));
        module.setDomain(this);
        this.modulesByName.put(contextName, module);
        this.modules.add(module);
        try {
            module.createDependencies();
            if (!module.isImportAll()) {
                ClassLoadingSpace space = new ClassLoadingSpace();
                space.join(module);
            }
        }
        catch (Throwable t) {
            this.removeModule(module);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException("Error adding module " + module, t);
        }
    }

    protected synchronized void removeModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        log.debug((Object)(this + " remove module " + module));
        ClassLoadingSpace space = module.getClassLoadingSpace();
        if (space != null) {
            space.split(module);
        }
        module.removeDependencies();
        this.modules.remove(module);
        this.modulesByName.remove(module.getContextName());
        module.setDomain(null);
    }

    public Module getModule(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null module name");
        }
        Module module = this.modulesByName.get(name);
        if (module != null) {
            return module;
        }
        Domain parent = this.getParentDomain();
        if (parent != null) {
            return parent.getModule(name);
        }
        return null;
    }

    List<Capability> mergeGlobalCapabilities(List<Capability> capabilities) {
        return this.classLoading.mergeGlobalCapabilities(capabilities);
    }

    protected Module resolveModule(Module module, Requirement requirement) {
        LifeCycle lifeCycle;
        Module result = this.doResolveModule(module, requirement);
        if (result == null && this.classLoading.resolve(new ResolutionContext(this, module, requirement))) {
            result = this.doResolveModule(module, requirement);
        }
        if (result != null && (lifeCycle = result.getLifeCycle()) != null && lifeCycle.isLazyResolve() && !lifeCycle.isResolved()) {
            try {
                lifeCycle.resolve();
            }
            catch (Throwable t) {
                log.warn((Object)("Error in resolve for " + result), t);
            }
        }
        return result;
    }

    protected Module doResolveModule(Module module, Requirement requirement) {
        Module result;
        Domain parentDomain = null;
        if (this.parentDomainName != null && (parentDomain = this.getParentDomain()) == null) {
            return null;
        }
        if (parentDomain != null && this.parentFirst && (result = parentDomain.resolveModule(module, requirement)) != null) {
            return result;
        }
        Module firstMatch = null;
        for (Module other : this.modules) {
            List<Capability> capabilities = other.getCapabilities();
            if (capabilities == null) continue;
            for (Capability capability : capabilities) {
                if (!capability.resolves(module, requirement)) continue;
                if (firstMatch != null) {
                    String otherName = other.getName() + ":" + other.getVersion();
                    String firstName = firstMatch.getName() + ":" + firstMatch.getVersion();
                    log.debug((Object)("Requirement " + requirement + " resolves agaist " + firstName + " and " + otherName + " - using first."));
                }
                if (firstMatch != null) continue;
                firstMatch = other;
            }
        }
        if (firstMatch != null) {
            return firstMatch;
        }
        if (parentDomain != null && !this.parentFirst) {
            return parentDomain.resolveModule(module, requirement);
        }
        return null;
    }

    @Override
    public Module getModuleForClass(Class<?> clazz) {
        return Module.getModuleForClass(clazz);
    }

    @Override
    public Collection<Module> getModules(String name, VersionRange range) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        HashSet<Module> result = new HashSet<Module>();
        this.getModulesInternal(name, range, result);
        return result;
    }

    void getModulesInternal(String name, VersionRange range, Collection<Module> result) {
        if (range == null) {
            range = VersionRange.ALL_VERSIONS;
        }
        block0: for (Module module : this.modules) {
            List<Capability> capabilities = module.getCapabilitiesRaw();
            if (capabilities != null && !capabilities.isEmpty()) {
                ModuleRequirement requirement = new ModuleRequirement(name, range);
                for (Capability capability : capabilities) {
                    if (!capability.resolves(module, requirement)) continue;
                    result.add(module);
                    continue block0;
                }
                continue;
            }
            if (!name.equals(module.getName()) || !range.isInRange(module.getVersion())) continue;
            result.add(module);
            return;
        }
    }

    @Override
    public Collection<ImportModule> getImportedModules(String name, VersionRange range) {
        HashSet<ImportModule> result = new HashSet<ImportModule>();
        this.getImportingModulesInternal(name, range, result);
        return result;
    }

    void getImportingModulesInternal(String name, VersionRange range, Collection<ImportModule> result) {
        if (range == null) {
            range = VersionRange.ALL_VERSIONS;
        }
        for (Module module : this.modules) {
            List<RequirementDependencyItem> requirementDependencyItems = module.getDependencies();
            if (requirementDependencyItems == null || requirementDependencyItems.isEmpty()) continue;
            for (RequirementDependencyItem dependencyItem : requirementDependencyItems) {
                Requirement requirement = dependencyItem.getRequirement();
                if (!(requirement instanceof ModuleRequirement) || !dependencyItem.isResolved()) continue;
                ModuleRequirement moduleRequirement = (ModuleRequirement)requirement;
                if (name != null && !name.equals(moduleRequirement.getName()) || !range.isConsistent(moduleRequirement.getVersionRange())) continue;
                Module other = module.resolveModule(dependencyItem, true);
                ImportModule importModule = new ImportModule(other);
                result.add(importModule);
            }
        }
    }

    @Override
    public Collection<ExportPackage> getExportedPackages(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        return module.getExportedPackages();
    }

    @Override
    public Collection<ExportPackage> getExportedPackages(String name, VersionRange range) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        HashSet<ExportPackage> result = new HashSet<ExportPackage>();
        this.getExportedPackagesInternal(name, range, result);
        return result;
    }

    void getExportedPackagesInternal(String name, VersionRange range, Collection<ExportPackage> result) {
        if (range == null) {
            range = VersionRange.ALL_VERSIONS;
        }
        block0: for (Module module : this.modules) {
            List<Capability> capabilities = module.getCapabilitiesRaw();
            if (capabilities == null || capabilities.isEmpty()) continue;
            PackageRequirement requirement = new PackageRequirement(name, range);
            for (Capability capability : capabilities) {
                if (!(capability instanceof PackageCapability) || !capability.resolves(module, requirement)) continue;
                ExportPackage exportPackage = new ExportPackage(module, (PackageCapability)capability);
                result.add(exportPackage);
                continue block0;
            }
        }
    }

    @Override
    public void refreshModules(Module ... modules) throws Exception {
        Module.refreshModules(modules);
    }

    @Override
    public boolean resolveModules(Module ... modules) throws Exception {
        return Module.resolveModules(modules);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append('{').append(this.getName()).append('}');
        return builder.toString();
    }
}

