/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.classloader.plugins.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContext {
    private URL url;
    private ClassLoader classLoader;
    private String resourceName;

    public ResourceContext(URL url, String resourceName, ClassLoader classLoader) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Null resourceName");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.url = url;
        this.resourceName = resourceName;
        this.classLoader = classLoader;
    }

    public URL getUrl() {
        return this.url;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getClassName() {
        return ClassLoaderUtils.resourceNameToClassName((String)this.getResourceName());
    }

    public boolean isClass() {
        return this.resourceName.endsWith(".class");
    }

    public Class<?> loadClass() {
        String className = this.getClassName();
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected error loading class: " + className, e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    public byte[] getBytes() throws IOException {
        return ClassLoaderUtils.loadBytes((InputStream)this.getInputStream());
    }
}

