/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.deployment.BeanArchiveMetadata;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.BeansXmlParser;
import org.jboss.as.weld.deployment.UrlScanner;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldDeploymentMetadata;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.injection.spi.JpaInjectionServices;

public class ExternalBeanArchiveProcessor
implements DeploymentUnitProcessor {
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Module module;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WeldDeploymentMetadata cdiDeploymentMetadata = (WeldDeploymentMetadata)deploymentUnit.getAttachment(WeldDeploymentMetadata.ATTACHMENT_KEY);
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            return;
        }
        String beanArchiveIdPrefix = deploymentUnit.getName() + ".external.";
        ArrayList<DeploymentUnit> deploymentUnits = new ArrayList<DeploymentUnit>();
        deploymentUnits.add(deploymentUnit);
        deploymentUnits.addAll(deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS));
        BeansXmlParser parser = new BeansXmlParser();
        HashMap<URL, ArrayList<DeploymentUnit>> deploymentUnitMap = new HashMap<URL, ArrayList<DeploymentUnit>>();
        HashSet<URL> existing = new HashSet<URL>();
        for (DeploymentUnit deploymentUnit2 : deploymentUnits) {
            try {
                ResourceRoot deploymentRoot;
                VirtualFile beans;
                WeldDeploymentMetadata weldDeploymentMetadata = (WeldDeploymentMetadata)deploymentUnit2.getAttachment(WeldDeploymentMetadata.ATTACHMENT_KEY);
                if (weldDeploymentMetadata == null) continue;
                for (BeanArchiveMetadata md : weldDeploymentMetadata.getBeanArchiveMetadata()) {
                    URL file = md.getBeansXmlFile().toURL();
                    existing.add(file);
                }
                if (!deploymentUnit2.getName().endsWith(".war") || !(beans = (deploymentRoot = (ResourceRoot)deploymentUnit2.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild(META_INF_BEANS_XML)).exists()) continue;
                existing.add(beans.toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        for (DeploymentUnit deploymentUnit3 : deploymentUnits) {
            module = (Module)deploymentUnit3.getAttachment(Attachments.MODULE);
            if (module == null) {
                return;
            }
            try {
                Enumeration resources = module.getClassLoader().getResources(META_INF_BEANS_XML);
                while (resources.hasMoreElements()) {
                    URL beansXml = (URL)resources.nextElement();
                    if (existing.contains(beansXml)) continue;
                    WeldLogger.DEPLOYMENT_LOGGER.debugf("Found external beans.xml: %s", beansXml.toString());
                    ArrayList<DeploymentUnit> dus = (ArrayList<DeploymentUnit>)deploymentUnitMap.get(beansXml);
                    if (dus == null) {
                        dus = new ArrayList<DeploymentUnit>();
                        deploymentUnitMap.put(beansXml, dus);
                    }
                    dus.add(deploymentUnit3);
                }
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        for (Map.Entry entry : deploymentUnitMap.entrySet()) {
            module = (Module)((DeploymentUnit)((List)entry.getValue()).get(0)).getAttachment(Attachments.MODULE);
            BeansXml beansXml = this.parseBeansXml((URL)entry.getKey(), parser, deploymentUnit);
            UrlScanner urlScanner = new UrlScanner();
            ArrayList<String> discoveredClasses = new ArrayList<String>();
            if (!urlScanner.handleBeansXml((URL)entry.getKey(), discoveredClasses)) continue;
            BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(new HashSet<String>(discoveredClasses), beansXml, module, beanArchiveIdPrefix + ((URL)entry.getKey()).toExternalForm());
            BeanDeploymentModule bdm = new BeanDeploymentModule(Collections.singleton(bda));
            WeldJpaInjectionServices jpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit, deploymentUnit.getServiceRegistry());
            bdm.addService(JpaInjectionServices.class, jpaInjectionServices);
            deploymentUnit.addToAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES, (Object)bdm);
            for (DeploymentUnit du : (List)entry.getValue()) {
                du.addToAttachmentList(WeldAttachments.VISIBLE_ADDITIONAL_BEAN_DEPLOYMENT_MODULE, (Object)bdm);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BeansXml parseBeansXml(URL beansXmlFile, BeansXmlParser parser, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        return parser.parse(beansXmlFile, SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
    }
}

