/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.util.HashMap;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.injection.spi.JpaInjectionServices;

public class WeldJpaInjectionServices
implements JpaInjectionServices {
    private final DeploymentUnit deploymentUnit;
    private final ServiceRegistry serviceRegistry;

    public WeldJpaInjectionServices(DeploymentUnit deploymentUnit, ServiceRegistry serviceRegistry) {
        this.deploymentUnit = deploymentUnit;
        this.serviceRegistry = serviceRegistry;
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        PersistenceContext context = (PersistenceContext)injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class);
        if (context == null) {
            throw new RuntimeException("Could not find @PersistenceContext annotation on " + injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.serviceRegistry.getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return new TransactionScopedEntityManager(scopedPuName, new HashMap(), persistenceUnitService.getEntityManagerFactory());
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        PersistenceUnit context = (PersistenceUnit)injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class);
        if (context == null) {
            throw new RuntimeException("Could not find @PersistenceUnit annotation on " + injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.serviceRegistry.getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return persistenceUnitService.getEntityManagerFactory();
    }

    public void cleanup() {
    }

    private String getScopedPUName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        PersistenceUnitMetadata scopedPu = PersistenceUnitSearch.resolvePersistenceUnitSupplier((DeploymentUnit)deploymentUnit, (String)persistenceUnitName);
        if (null == scopedPu) {
            throw new RuntimeException("Error injecting persistence unit into CDI managed bean. Can't find a persistence unit named " + persistenceUnitName + " in deployment " + deploymentUnit.getName());
        }
        return scopedPu.getScopedPersistenceUnitName();
    }
}

