/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.ejb.BusinessInterfaceDescriptorImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;

public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private final EJBComponentDescription componentDescription;
    private final BeanDeploymentArchiveImpl beanDeploymentArchive;
    private final Set<BusinessInterfaceDescriptor<?>> localInterfaces;
    private final ServiceName baseName;

    public EjbDescriptorImpl(EJBComponentDescription componentDescription, BeanDeploymentArchiveImpl beanDeploymentArchive, DeploymentUnit deploymentUnit) {
        this.componentDescription = componentDescription;
        this.beanDeploymentArchive = beanDeploymentArchive;
        SessionBeanComponentDescription description = componentDescription instanceof SessionBeanComponentDescription ? (SessionBeanComponentDescription)componentDescription : null;
        HashSet localInterfaces = new HashSet();
        if (componentDescription.getViews() != null) {
            for (ViewDescription view : componentDescription.getViews()) {
                if (description != null && this.getMethodIntf(view) != MethodIntf.LOCAL) continue;
                String viewClassName = view.getViewClassName();
                localInterfaces.add(new BusinessInterfaceDescriptorImpl(beanDeploymentArchive, viewClassName));
            }
        }
        this.localInterfaces = localInterfaces;
        this.baseName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{componentDescription.getComponentName()});
    }

    private MethodIntf getMethodIntf(ViewDescription view) {
        if (view instanceof EJBViewDescription) {
            EJBViewDescription ejbView = (EJBViewDescription)view;
            return ejbView.getMethodIntf();
        }
        return null;
    }

    public Class<T> getBeanClass() {
        return ((ResourceLoader)this.beanDeploymentArchive.getServices().get(ResourceLoader.class)).classForName(this.componentDescription.getEJBClassName());
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localInterfaces;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        return Collections.emptySet();
    }

    public String getEjbName() {
        return this.componentDescription.getEJBName();
    }

    public Collection<Method> getRemoveMethods() {
        return Collections.emptySet();
    }

    public boolean isStateless() {
        return this.componentDescription.isStateless();
    }

    public boolean isSingleton() {
        return this.componentDescription.isSingleton();
    }

    public boolean isStateful() {
        return this.componentDescription.isStateful();
    }

    public boolean isMessageDriven() {
        return this.componentDescription.isMessageDriven();
    }

    public EJBComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public ServiceName getBaseName() {
        return this.baseName;
    }

    public ServiceName getCreateServiceName() {
        return this.baseName.append(new String[]{"CREATE"});
    }

    public ServiceName getStartServiceName() {
        return this.baseName.append(new String[]{"START"});
    }
}

