/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.ee.component.InjectionFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.injection.WeldComponentInjectionService;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldInjectionFactory
implements InjectionFactory {
    private final ServiceName beanManagerServiceName;
    private final ServiceTarget serviceTarget;
    private final DeploymentUnit deploymentUnit;
    private final ClassLoader classLoader;

    public WeldInjectionFactory(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, ClassLoader classLoader) {
        this.serviceTarget = serviceTarget;
        this.deploymentUnit = deploymentUnit;
        this.beanManagerServiceName = deploymentUnit.getServiceName().append(BeanManagerService.NAME);
        this.classLoader = classLoader;
    }

    public ComponentInjector createInjector(AbstractComponentConfiguration component) {
        ServiceName serviceName = this.deploymentUnit.getServiceName().append(new String[]{"component", component.getComponentName(), "weldinjector"});
        WeldComponentInjectionService service = new WeldComponentInjectionService(serviceName, component.getComponentClass(), this.classLoader);
        this.serviceTarget.addService(serviceName, (Service)service).addDependency(this.beanManagerServiceName, BeanManagerImpl.class, service.getBeanManager()).install();
        return service;
    }
}

