/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;

public class WebIntegrationProcessor
implements DeploymentUnitProcessor {
    private final ListenerMetaData WBL = new ListenerMetaData();
    private final ListenerMetaData JIL;
    private final FilterMetaData CPF;
    private final FilterMappingMetaData CPFM;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.weld");

    public WebIntegrationProcessor() {
        this.WBL.setListenerClass("org.jboss.weld.servlet.WeldListener");
        this.JIL = new ListenerMetaData();
        this.JIL.setListenerClass("org.jboss.as.weld.webtier.jsp.JspInitializationListener");
        this.CPF = new FilterMetaData();
        this.CPF.setFilterName("Weld Conversation Propagation Filter");
        this.CPF.setFilterClass("org.jboss.weld.servlet.ConversationPropagationFilter");
        this.CPFM = new FilterMappingMetaData();
        this.CPFM.setFilterName("Weld Conversation Propagation Filter");
        this.CPFM.setUrlPatterns(Arrays.asList("/*"));
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            log.info((Object)"Not installing Weld web tier integration as no war metadata found");
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            log.info((Object)"Not installing Weld web tier integration as no web metadata found");
            return;
        }
        ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
        if (listeners == null) {
            listeners = new ArrayList<ListenerMetaData>();
            webMetaData.setListeners(listeners);
        }
        listeners.add(0, this.WBL);
        listeners.add(1, this.JIL);
        FiltersMetaData filters = webMetaData.getFilters();
        if (filters == null) {
            filters = new FiltersMetaData();
            webMetaData.setFilters(filters);
        }
        filters.add((MappableMetaData)this.CPF);
        ArrayList<FilterMappingMetaData> filterMappings = webMetaData.getFilterMappings();
        if (filterMappings == null) {
            filterMappings = new ArrayList<FilterMappingMetaData>();
            webMetaData.setFilterMappings(filterMappings);
        }
        filterMappings.add(this.CPFM);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

