/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.webtier.jsf;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.weld.webtier.jsf.DummyELResolver;
import org.jboss.as.weld.webtier.jsf.ForwardingApplication;
import org.jboss.as.weld.webtier.jsf.ForwardingELResolver;
import org.jboss.weld.el.WeldELContextListener;

public class WeldApplication
extends ForwardingApplication {
    private final Application application;
    private volatile ExpressionFactory expressionFactory;
    private AdjustableELResolver elResolver;
    private volatile boolean initialized;
    private volatile BeanManager beanManager;

    public WeldApplication(Application application) {
        this.application = application;
        application.addELContextListener((ELContextListener)new WeldELContextListener());
        this.elResolver = new AdjustableELResolver();
        this.elResolver.setDelegate(new DummyELResolver());
        application.addELResolver((ELResolver)this.elResolver);
    }

    private void init() {
        if (!this.initialized && this.beanManager() != null) {
            this.elResolver.setDelegate(this.beanManager().getELResolver());
            this.initialized = true;
        }
    }

    @Override
    protected Application delegate() {
        this.init();
        return this.application;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        this.init();
        if (this.expressionFactory == null) {
            BeanManager bm = this.beanManager();
            this.expressionFactory = bm == null ? this.application.getExpressionFactory() : bm.wrapExpressionFactory(this.application.getExpressionFactory());
        }
        return this.expressionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManager beanManager() {
        if (this.beanManager == null) {
            WeldApplication weldApplication = this;
            synchronized (weldApplication) {
                if (this.beanManager == null) {
                    try {
                        this.beanManager = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
                    }
                    catch (NamingException e) {
                        return null;
                    }
                }
            }
        }
        return this.beanManager;
    }

    private static class AdjustableELResolver
    extends ForwardingELResolver {
        private ELResolver delegate;

        private AdjustableELResolver() {
        }

        public void setDelegate(ELResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ELResolver delegate() {
            return this.delegate;
        }
    }
}

