/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Method;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.injection.spi.EjbInjectionServices;

public class WeldEjbInjectionServices
implements EjbInjectionServices {
    private final ServiceRegistry serviceRegistry;
    private final EEModuleDescription moduleDescription;

    public WeldEjbInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription) {
        this.serviceRegistry = serviceRegistry;
        this.moduleDescription = moduleDescription;
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        EJB ejb = (EJB)injectionPoint.getAnnotated().getAnnotation(EJB.class);
        if (ejb == null) {
            throw new RuntimeException("@Ejb annotation not found on " + injectionPoint.getMember());
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        if (!ejb.lookup().equals("")) {
            ServiceName ejbServiceName = ContextNames.serviceNameOfContext((String)this.moduleDescription.getAppName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (String)ejb.lookup());
            ServiceController controller = this.serviceRegistry.getRequiredService(ejbServiceName);
            ManagedReferenceFactory factory = (ManagedReferenceFactory)controller.getValue();
            return factory.getReference().getInstance();
        }
        throw new RuntimeException("Currently only the lookup attribute is supported on CDI @EJB injection " + injectionPoint);
    }

    public void cleanup() {
    }
}

