/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.weld.injection.SecurityActions;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class WeldComponentInjectionService
implements ComponentInjector,
Service<ComponentInjector> {
    private final ServiceName serviceName;
    private final Class<?> componentClass;
    private final InjectedValue<BeanManagerImpl> beanManager = new InjectedValue();
    private volatile List<Injection> injectionPoints;
    private final ClassLoader classLoader;

    public WeldComponentInjectionService(ServiceName serviceName, Class<?> componentClass, ClassLoader classLoader) {
        this.serviceName = serviceName;
        this.componentClass = componentClass;
        this.classLoader = classLoader;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeldInjectionHandle inject(Object instance) {
        ClassLoader oldTCCL = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.classLoader);
            BeanManagerImpl bm = (BeanManagerImpl)this.beanManager.getValue();
            WeldInjectionHandle weldHandle = new WeldInjectionHandle();
            for (Injection injectionPoint : this.injectionPoints) {
                weldHandle.addAll(injectionPoint.inject(instance, (BeanManager)bm));
            }
            WeldInjectionHandle weldInjectionHandle = weldHandle;
            return weldInjectionHandle;
        }
        finally {
            SecurityActions.setContextClassLoader(oldTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ClassLoader oldTCCL = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.classLoader);
            BeanManagerImpl bm = (BeanManagerImpl)this.beanManager.getValue();
            ClassTransformer transformer = (ClassTransformer)bm.getServices().get(ClassTransformer.class);
            ArrayList<Injection> injectionPoints = new ArrayList<Injection>();
            WeldClass weldClass = transformer.loadClass(this.componentClass);
            for (AnnotatedField field : weldClass.getFields()) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                for (Annotation annotation : field.getAnnotations()) {
                    if (!bm.isQualifier(annotation.annotationType())) continue;
                    qualifiers.add(annotation);
                }
                FieldInjectionPoint ip = new FieldInjectionPoint(field, qualifiers);
                Set beans = bm.getBeans((InjectionPoint)ip);
                if (beans.size() > 1) {
                    throw new StartException("Error resolving CDI injection point " + field + " on " + this.componentClass + ". Injection points is ambiguous " + beans);
                }
                if (beans.isEmpty()) {
                    throw new StartException("Error resolving CDI injection point " + field + " on " + this.componentClass + ". No bean satisfies the injection point.");
                }
                Bean bean = bm.resolve(beans);
                injectionPoints.add(new CDIFieldInjection(field.getJavaMember(), bean));
            }
            for (AnnotatedMethod method : weldClass.getMethods()) {
                if (!method.isAnnotationPresent(Inject.class)) continue;
                ArrayList parameterBeans = new ArrayList();
                for (AnnotatedParameter param : method.getParameters()) {
                    HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                    for (Annotation annotation : param.getAnnotations()) {
                        if (!bm.isQualifier(annotation.annotationType())) continue;
                        qualifiers.add(annotation);
                    }
                    ParameterInjectionPoint ip = new ParameterInjectionPoint(param, qualifiers);
                    Set beans = bm.getBeans((InjectionPoint)ip);
                    if (beans.size() > 1) {
                        throw new StartException("Error resolving CDI injection point " + param + " on " + this.componentClass + ". Injection points is ambiguous " + beans);
                    }
                    if (beans.isEmpty()) {
                        throw new StartException("Error resolving CDI injection point " + param + " on " + this.componentClass + ". No bean satisfies the injection point.");
                    }
                    Bean bean = bm.resolve(beans);
                    parameterBeans.add(bean);
                }
                injectionPoints.add(new CDIMethodInjection(method.getJavaMember(), parameterBeans));
            }
            this.injectionPoints = injectionPoints;
        }
        finally {
            SecurityActions.setContextClassLoader(oldTCCL);
        }
    }

    public void stop(StopContext context) {
        this.injectionPoints = null;
    }

    public ComponentInjector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<BeanManagerImpl> getBeanManager() {
        return this.beanManager;
    }

    private static final class ParameterInjectionPoint
    implements InjectionPoint {
        private final AnnotatedParameter<?> parameter;
        private final Set<Annotation> qualifiers;

        public ParameterInjectionPoint(AnnotatedParameter<?> parameter, Set<Annotation> qualifiers) {
            this.parameter = parameter;
            this.qualifiers = qualifiers;
        }

        public Type getType() {
            return this.parameter.getBaseType();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return this.parameter.getDeclaringCallable().getJavaMember();
        }

        public Annotated getAnnotated() {
            return this.parameter;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }

    private static final class FieldInjectionPoint
    implements InjectionPoint {
        private final AnnotatedField<?> field;
        private final Set<Annotation> qualifiers;

        public FieldInjectionPoint(AnnotatedField<?> field, Set<Annotation> qualifiers) {
            this.field = field;
            this.qualifiers = qualifiers;
        }

        public Type getType() {
            return this.field.getJavaMember().getGenericType();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return this.field.getJavaMember();
        }

        public Annotated getAnnotated() {
            return this.field;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return Modifier.isTransient(this.field.getJavaMember().getModifiers());
        }
    }

    private static final class CDIMethodInjection
    implements Injection {
        private final Method method;
        private final List<Bean<?>> beans;

        public CDIMethodInjection(final Method method, List<Bean<?>> beans) {
            this.beans = beans;
            this.method = method;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }

        @Override
        public Collection<CreationalContext<?>> inject(Object instance, BeanManager beanManager) {
            try {
                Object[] params = new Object[this.beans.size()];
                HashSet contexts = new HashSet();
                int i = 0;
                for (Bean<?> bean : this.beans) {
                    CreationalContext ctx = beanManager.createCreationalContext(bean);
                    contexts.add(ctx);
                    Object value = beanManager.getReference(bean, this.method.getParameterTypes()[i], ctx);
                    params[i++] = value;
                }
                this.method.invoke(instance, params);
                return contexts;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to perform CDI injection of initalizer method: " + this.method + " on " + instance.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to perform CDI injection of field: " + this.method + " on " + instance.getClass(), e);
            }
        }
    }

    private static final class CDIFieldInjection
    implements Injection {
        private final Field field;
        private final Bean<?> bean;

        public CDIFieldInjection(final Field field, Bean<?> bean) {
            this.bean = bean;
            this.field = field;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }

        @Override
        public Collection<CreationalContext<?>> inject(Object instance, BeanManager beanManager) {
            try {
                CreationalContext ctx = beanManager.createCreationalContext(this.bean);
                Object value = beanManager.getReference(this.bean, this.field.getGenericType(), ctx);
                this.field.set(instance, value);
                return Collections.singleton(ctx);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to perform CDI injection of field: " + this.field + " on " + instance.getClass(), e);
            }
        }
    }

    private static interface Injection {
        public Collection<CreationalContext<?>> inject(Object var1, BeanManager var2);
    }

    private static final class WeldInjectionHandle
    implements ComponentInjector.InjectionHandle {
        private final List<CreationalContext<?>> creationalContexts = new ArrayList();

        private WeldInjectionHandle() {
        }

        public void add(CreationalContext<?> ctx) {
            this.creationalContexts.add(ctx);
        }

        public void addAll(Collection<CreationalContext<?>> ctxs) {
            this.creationalContexts.addAll(ctxs);
        }

        public void uninject() {
            for (CreationalContext<?> ctx : this.creationalContexts) {
                ctx.release();
            }
        }
    }
}

