/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployer.Deployer;

public final class RemoteDeployer
implements Deployer {
    private static final Logger LOGGER = Logger.getLogger(RemoteDeployer.class);
    private static final int PORT = 9999;
    private static final String JBWS_DEPLOYER_AUTH_USER = "jbossws.deployer.authentication.username";
    private static final String JBWS_DEPLOYER_AUTH_PWD = "jbossws.deployer.authentication.password";
    private final Map<URL, String> url2Id = new HashMap<URL, String>();
    private final InetAddress address = InetAddress.getByName("127.0.0.1");
    private CallbackHandler callbackHandler = RemoteDeployer.getCallbackHandler();
    private ServerDeploymentManager deploymentManager = ServerDeploymentManager.Factory.create((InetAddress)this.address, (int)9999, (CallbackHandler)this.callbackHandler);

    public void deploy(URL archiveURL) throws Exception {
        DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan().add(archiveURL).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        String uniqueId = deployAction.getDeploymentUnitUniqueName();
        this.executeDeploymentPlan(plan, deployAction);
        this.url2Id.put(archiveURL, uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URL archiveURL) throws Exception {
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        String uniqueName = this.url2Id.get(archiveURL);
        if (uniqueName != null) {
            DeploymentPlan plan = builder.undeploy(uniqueName).remove(uniqueName).build();
            DeploymentAction deployAction = builder.getLastAction();
            try {
                this.executeDeploymentPlan(plan, deployAction);
            }
            finally {
                this.url2Id.remove(archiveURL);
            }
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        try {
            Exception deploymentException;
            ServerDeploymentActionResult actionResult;
            ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)this.deploymentManager.execute(plan).get();
            if (deployAction != null && (actionResult = planResult.getDeploymentActionResult(deployAction.getId())) != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
                throw deploymentException;
            }
        }
        catch (Exception e) {
            LOGGER.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)this.address, (int)9999, (CallbackHandler)this.callbackHandler);
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "security");
        op.get("address").add("security-domain", name);
        updates.add(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "security");
        op.get("address").add("security-domain", name);
        op.get("address").add("authentication", "classic");
        ModelNode loginModule = op.get("login-modules").add();
        loginModule.get("code").set("UsersRoles");
        loginModule.get("flag").set("required");
        op.get("operation-headers").get("allow-resource-service-restart").set(true);
        updates.add(op);
        ModelNode moduleOptions = loginModule.get("module-options");
        if (authenticationOptions != null) {
            for (String k : authenticationOptions.keySet()) {
                moduleOptions.add(k, authenticationOptions.get(k));
            }
        }
        RemoteDeployer.applyUpdates(updates, client);
    }

    public void removeSecurityDomain(String name) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)this.address, (int)9999, (CallbackHandler)this.callbackHandler);
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "security");
        op.get("address").add("security-domain", name);
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
        RemoteDeployer.applyUpdate(op, client);
    }

    private static void applyUpdates(List<ModelNode> updates, ModelControllerClient client) throws Exception {
        for (ModelNode update : updates) {
            RemoteDeployer.applyUpdate(update, client);
        }
    }

    private static void applyUpdate(ModelNode update, ModelControllerClient client) throws Exception {
        ModelNode result = client.execute(new OperationBuilder(update).build());
        RemoteDeployer.checkResult(result);
    }

    private static void checkResult(ModelNode result) throws Exception {
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                LOGGER.info((Object)result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new Exception(result.get("failure-description").toString());
            }
            throw new Exception("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    private static CallbackHandler getCallbackHandler() {
        final String username = RemoteDeployer.getSystemProperty(JBWS_DEPLOYER_AUTH_USER, null);
        if (username == null || "${jbossws.deployer.authentication.username}".equals(username)) {
            return null;
        }
        String pwd = RemoteDeployer.getSystemProperty(JBWS_DEPLOYER_AUTH_PWD, null);
        if ("${jbossws.deployer.authentication.password}".equals(pwd)) {
            pwd = null;
        }
        final String password = pwd;
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) continue;
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return AccessController.doPrivileged(action);
    }
}

