/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebSSLAdd;
import org.jboss.dmr.ModelType;

public class WebSSLDefinition
extends SimpleResourceDefinition {
    protected static final WebSSLDefinition INSTANCE = new WebSSLDefinition();
    protected static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName("name").setAllowNull(true).build();
    protected static final SimpleAttributeDefinition KEY_ALIAS = new SimpleAttributeDefinitionBuilder("key-alias", ModelType.STRING).setAllowNull(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition PASSWORD = new SimpleAttributeDefinitionBuilder("password", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CERTIFICATE_KEY_FILE = new SimpleAttributeDefinitionBuilder("certificate-key-file", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CIPHER_SUITE = new SimpleAttributeDefinitionBuilder("cipher-suite", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition PROTOCOL = new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition VERIFY_CLIENT = new SimpleAttributeDefinitionBuilder("verify-client", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition VERIFY_DEPTH = new SimpleAttributeDefinitionBuilder("verify-depth", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CERTIFICATE_FILE = new SimpleAttributeDefinitionBuilder("certificate-file", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CA_CERTIFICATE_FILE = new SimpleAttributeDefinitionBuilder("ca-certificate-file", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CA_CERTIFICATE_PASSWORD = new SimpleAttributeDefinitionBuilder("ca-certificate-password", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CA_REVOCATION_URL = new SimpleAttributeDefinitionBuilder("ca-revocation-url", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE_TYPE = new SimpleAttributeDefinitionBuilder("truststore-type", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition KEYSTORE_TYPE = new SimpleAttributeDefinitionBuilder("keystore-type", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition SESSION_CACHE_SIZE = new SimpleAttributeDefinitionBuilder("session-cache-size", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition SESSION_TIMEOUT = new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static SimpleAttributeDefinition[] SSL_ATTRIBUTES = new SimpleAttributeDefinition[]{KEY_ALIAS, PASSWORD, CERTIFICATE_KEY_FILE, CIPHER_SUITE, PROTOCOL, VERIFY_CLIENT, VERIFY_DEPTH, CERTIFICATE_FILE, CA_CERTIFICATE_FILE, CA_REVOCATION_URL, CA_CERTIFICATE_PASSWORD, KEYSTORE_TYPE, TRUSTSTORE_TYPE, SESSION_CACHE_SIZE, SESSION_TIMEOUT};

    private WebSSLDefinition() {
        super(WebExtension.SSL_PATH, (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("connector.ssl"), (OperationStepHandler)WebSSLAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public void registerAttributes(ManagementResourceRegistration ssl) {
        ssl.registerReadWriteAttribute((AttributeDefinition)NAME, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{NAME}));
        for (SimpleAttributeDefinition attr : SSL_ATTRIBUTES) {
            ssl.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
    }
}

