/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.core.StandardContext;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.web.ThreadSetupBindingListener;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.deployment.jsf.JsfInjectionProvider;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebDeploymentService
implements Service<Context> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.web");
    private final StandardContext context;
    private final InjectedValue<Realm> realm = new InjectedValue();
    private final WebInjectionContainer injectionContainer;
    private final List<SetupAction> setupActions;

    public WebDeploymentService(StandardContext context, WebInjectionContainer injectionContainer, List<SetupAction> setupActions) {
        this.context = context;
        this.injectionContainer = injectionContainer;
        this.setupActions = setupActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        this.context.setRealm((Realm)this.realm.getValue());
        JsfInjectionProvider.getInjectionContainer().set(this.injectionContainer);
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
        actions.addAll(this.setupActions);
        this.context.setThreadBindingListener((ThreadBindingListener)new ThreadSetupBindingListener(actions));
        try {
            try {
                this.context.create();
            }
            catch (Exception e) {
                throw new StartException("failed to create context", (Throwable)e);
            }
            try {
                this.context.start();
            }
            catch (LifecycleException e) {
                throw new StartException("failed to start context", (Throwable)e);
            }
            if (this.context.getState() != 1) {
                throw new StartException("failed to start context");
            }
            log.info((Object)("registering web context: " + this.context.getName()));
        }
        finally {
            JsfInjectionProvider.getInjectionContainer().set(null);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        try {
            this.context.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)"exception while stopping context", (Throwable)e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            log.error((Object)"exception while destroying context", (Throwable)e);
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        StandardContext context = this.context;
        if (context == null) {
            throw new IllegalStateException();
        }
        return context;
    }

    public InjectedValue<Realm> getRealm() {
        return this.realm;
    }
}

